/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.tf2;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.exceptions.WebApiException;
import com.github.koraktor.steamcondenser.steam.community.SteamId;
import com.github.koraktor.steamcondenser.steam.community.WebApi;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TF2GoldenWrench {
    private static Set<TF2GoldenWrench> goldenWrenches = null;
    private Date date;
    private int id;
    private int number;
    private SteamId owner;

    public static Set<TF2GoldenWrench> getGoldenWrenches() throws SteamCondenserException {
        if (goldenWrenches == null) {
            try {
                goldenWrenches = new HashSet<TF2GoldenWrench>();
                JSONObject data = new JSONObject(WebApi.getJSON("ITFItems_440", "GetGoldenWrenches", 2));
                JSONArray wrenches = data.getJSONObject("results").getJSONArray("wrenches");
                for (int i = 0; i < wrenches.length(); ++i) {
                    goldenWrenches.add(new TF2GoldenWrench(wrenches.getJSONObject(i)));
                }
            }
            catch (JSONException e) {
                throw new WebApiException("Could not parse the JSON data.", e);
            }
        }
        return goldenWrenches;
    }

    private TF2GoldenWrench(JSONObject wrenchData) throws SteamCondenserException {
        try {
            this.date = new Date(wrenchData.getLong("timestamp"));
            this.id = wrenchData.getInt("itemID");
            this.number = wrenchData.getInt("wrenchNumber");
            this.owner = SteamId.create(wrenchData.getLong("steamID"), false);
        }
        catch (JSONException e) {
            throw new WebApiException("Could not parse JSON data.", e);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public int getId() {
        return this.id;
    }

    public int getNumber() {
        return this.number;
    }

    public SteamId getOwner() {
        return this.owner;
    }
}

