/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.tf2;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameItem;
import com.github.koraktor.steamcondenser.steam.community.tf2.TF2Inventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TF2Item
extends GameItem {
    private static final String[] CLASSES = new String[]{"scout", "sniper", "soldier", "demoman", "medic", "heavy", "pyro", "spy"};
    private Map<String, Boolean> equipped = new HashMap<String, Boolean>();

    public TF2Item(TF2Inventory inventory, JSONObject itemData) throws JSONException, SteamCondenserException {
        super(inventory, itemData);
        for (int classId = 0; classId < CLASSES.length; ++classId) {
            this.equipped.put(CLASSES[classId], (itemData.getLong("inventory") & (long)(1 << 16 + classId)) != 0L);
        }
    }

    public List<String> getClassesEquipped() {
        ArrayList<String> classesEquipped = new ArrayList<String>();
        for (Map.Entry<String, Boolean> classEquipped : this.equipped.entrySet()) {
            if (!classEquipped.getValue().booleanValue()) continue;
            classesEquipped.add(classEquipped.getKey());
        }
        return classesEquipped;
    }

    public boolean isEquipped() {
        return this.equipped.containsValue(true);
    }
}

