/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.community.tf2;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.community.GameInventory;
import com.github.koraktor.steamcondenser.steam.community.GameStats;
import com.github.koraktor.steamcondenser.steam.community.XMLData;
import com.github.koraktor.steamcondenser.steam.community.tf2.TF2Class;
import com.github.koraktor.steamcondenser.steam.community.tf2.TF2ClassFactory;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TF2Stats
extends GameStats {
    private int accumulatedPoints;
    private ArrayList<TF2Class> classStats;
    private GameInventory inventory;
    private int totalPlayTime;

    public TF2Stats(Object steamId) throws SteamCondenserException {
        this(steamId, false);
    }

    public TF2Stats(Object steamId, boolean beta) throws SteamCondenserException {
        super(steamId, beta ? "520" : "tf2");
        if (this.isPublic()) {
            this.accumulatedPoints = this.xmlData.getInteger("stats", "accumulatedPoints");
            this.totalPlayTime = this.xmlData.getInteger("stats", "secondsPlayedAllClassesLifetime");
        }
    }

    public int getAccumulatedPoints() {
        return this.accumulatedPoints;
    }

    public int getTotalPlayTime() {
        return this.totalPlayTime;
    }

    public ArrayList<TF2Class> getClassStats() {
        if (!this.isPublic()) {
            return null;
        }
        if (this.classStats == null) {
            this.classStats = new ArrayList();
            for (XMLData classData : this.xmlData.getElements("stats", "classData")) {
                this.classStats.add(TF2ClassFactory.getTF2Class(classData));
            }
        }
        return this.classStats;
    }

    public GameInventory getInventory() throws SteamCondenserException {
        if (!this.isPublic()) {
            return null;
        }
        if (this.inventory == null) {
            this.inventory = GameInventory.create(this.getGame().getAppId(), this.user.getSteamId64());
        }
        return this.inventory;
    }
}

