/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.packets;

import com.github.koraktor.steamcondenser.exceptions.PacketFormatException;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2A_SERVER_BATCH_Paket
extends SteamPacket {
    private Vector<String> serverArray;

    public M2A_SERVER_BATCH_Paket(byte[] data) throws PacketFormatException {
        super((byte)102, data);
        if (this.contentData.getByte() != 10) {
            throw new PacketFormatException("Master query response is missing additional 0x0A byte.");
        }
        this.serverArray = new Vector();
        do {
            int firstOctet = this.contentData.getByte() & 0xFF;
            int secondOctet = this.contentData.getByte() & 0xFF;
            int thirdOctet = this.contentData.getByte() & 0xFF;
            int fourthOctet = this.contentData.getByte() & 0xFF;
            int portNumber = this.contentData.getShort() & 0xFFFF;
            this.serverArray.add(firstOctet + "." + secondOctet + "." + thirdOctet + "." + fourthOctet + ":" + portNumber);
        } while (this.contentData.remaining() > 0);
    }

    public Vector<String> getServers() {
        return this.serverArray;
    }
}

