/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.packets;

import com.github.koraktor.steamcondenser.exceptions.PacketFormatException;
import com.github.koraktor.steamcondenser.steam.SteamPlayer;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2A_PLAYER_Packet
extends SteamPacket {
    private HashMap<String, SteamPlayer> playerHash;

    public S2A_PLAYER_Packet(byte[] dataBytes) throws PacketFormatException {
        super((byte)68, dataBytes);
        if (this.contentData.getLength() == 0) {
            throw new PacketFormatException("Wrong formatted S2A_PLAYER response packet.");
        }
        this.playerHash = new HashMap(this.contentData.getByte());
        while (this.contentData.hasRemaining()) {
            int playerId = this.contentData.getByte() & 0xFF;
            String playerName = this.contentData.getString();
            this.playerHash.put(playerName, new SteamPlayer(playerId, playerName, Integer.reverseBytes(this.contentData.getInt()), Float.intBitsToFloat(Integer.reverseBytes(this.contentData.getInt()))));
        }
    }

    public HashMap<String, SteamPlayer> getPlayerHash() {
        return this.playerHash;
    }
}

