/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.packets;

import com.github.koraktor.steamcondenser.exceptions.PacketFormatException;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2A_RULES_Packet
extends SteamPacket {
    private HashMap<String, String> rulesHash;

    public S2A_RULES_Packet(byte[] dataBytes) throws PacketFormatException {
        super((byte)69, dataBytes);
        if (this.contentData.getLength() == 0) {
            throw new PacketFormatException("Wrong formatted S2A_RULES response packet.");
        }
        int rulesCount = Short.reverseBytes(this.contentData.getShort());
        this.rulesHash = new HashMap(rulesCount);
        for (int i = 0; i < rulesCount; ++i) {
            String rule = this.contentData.getString();
            String value = this.contentData.getString();
            if (rule.equals("")) break;
            this.rulesHash.put(rule, value);
        }
    }

    public HashMap<String, String> getRulesHash() {
        return this.rulesHash;
    }
}

