/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.packets;

import com.github.koraktor.steamcondenser.PacketBuffer;
import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2M_HEARTBEAT2_Packet
extends SteamPacket {
    private static final Map<String, Object> DEFAULT_DATA = new HashMap<String, Object>(){
        {
            this.put("appid", 320);
            this.put("bot", 0);
            this.put("challenge", null);
            this.put("dedicated", 0);
            this.put("gamedir", "hl2mp");
            this.put("gameport", 27015);
            this.put("gametype", "ctf");
            this.put("lan", 1);
            this.put("map", "null");
            this.put("max", 24);
            this.put("os", "l");
            this.put("password", 0);
            this.put("players", 0);
            this.put("product", "hl2dm");
            this.put("protocol", 7);
            this.put("region", 255);
            this.put("secure", 0);
            this.put("specport", 0);
            this.put("type", "d");
            this.put("version", "1.0.0.0");
        }
    };

    public S2M_HEARTBEAT2_Packet(Map<String, Object> data) throws SteamCondenserException {
        super((byte)48);
        HashMap<String, Object> newData = new HashMap<String, Object>();
        newData.putAll(DEFAULT_DATA);
        newData.putAll(data);
        if (newData.get("challenge") == null) {
            throw new SteamCondenserException("You have to provide a challenge number when sending a heartbeat to a master server.");
        }
        String bytes = "\n";
        for (Map.Entry entry : newData.entrySet()) {
            bytes = bytes + "\\" + (String)entry.getKey() + "\\" + entry.getValue();
        }
        bytes = bytes + "\n";
        this.contentData = new PacketBuffer(bytes.getBytes());
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[1 + this.contentData.array().length];
        bytes[0] = this.headerData;
        System.arraycopy(this.contentData.array(), 0, bytes, 1, this.contentData.array().length);
        return bytes;
    }
}

