/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.packets;

import com.github.koraktor.steamcondenser.PacketBuffer;

public abstract class SteamPacket {
    public static final byte A2S_INFO_HEADER = 84;
    public static final byte S2A_INFO2_HEADER = 73;
    public static final byte S2A_INFO_DETAILED_HEADER = 109;
    public static final byte A2S_PLAYER_HEADER = 85;
    public static final byte S2A_PLAYER_HEADER = 68;
    public static final byte A2S_RULES_HEADER = 86;
    public static final byte S2A_RULES_HEADER = 69;
    public static final byte A2S_SERVERQUERY_GETCHALLENGE_HEADER = 87;
    public static final byte S2C_CHALLENGE_HEADER = 65;
    public static final byte A2M_GET_SERVERS_BATCH2_HEADER = 49;
    public static final byte C2M_CHECKMD5_HEADER = 77;
    public static final byte M2A_SERVER_BATCH_HEADER = 102;
    public static final byte M2C_ISVALIDMD5_HEADER = 78;
    public static final byte M2S_REQUESTRESTART_HEADER = 79;
    public static final byte RCON_GOLDSRC_CHALLENGE_HEADER = 99;
    public static final byte RCON_GOLDSRC_NO_CHALLENGE_HEADER = 57;
    public static final byte RCON_GOLDSRC_RESPONSE_HEADER = 108;
    public static final byte S2A_LOGSTRING_HEADER = 82;
    public static final byte S2M_HEARTBEAT2_HEADER = 48;
    protected PacketBuffer contentData;
    protected byte headerData;

    protected SteamPacket(byte headerData) {
        this(headerData, new byte[0]);
    }

    protected SteamPacket(byte headerData, byte[] contentBytes) {
        this.contentData = new PacketBuffer(contentBytes);
        this.headerData = headerData;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.contentData.getLength() + 5];
        bytes[0] = -1;
        bytes[1] = -1;
        bytes[2] = -1;
        bytes[3] = -1;
        bytes[4] = this.headerData;
        System.arraycopy(this.contentData.array(), 0, bytes, 5, bytes.length - 5);
        return bytes;
    }
}

