/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.packets;

import com.github.koraktor.steamcondenser.Helper;
import com.github.koraktor.steamcondenser.exceptions.PacketFormatException;
import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.A2S_INFO_Packet;
import com.github.koraktor.steamcondenser.steam.packets.A2S_PLAYER_Packet;
import com.github.koraktor.steamcondenser.steam.packets.A2S_RULES_Packet;
import com.github.koraktor.steamcondenser.steam.packets.A2S_SERVERQUERY_GETCHALLENGE_Packet;
import com.github.koraktor.steamcondenser.steam.packets.M2A_SERVER_BATCH_Paket;
import com.github.koraktor.steamcondenser.steam.packets.M2C_ISVALIDMD5_Packet;
import com.github.koraktor.steamcondenser.steam.packets.M2S_REQUESTRESTART_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2A_INFO2_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2A_INFO_DETAILED_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2A_LOGSTRING_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2A_PLAYER_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2A_RULES_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2C_CHALLENGE_Packet;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONGoldSrcResponsePacket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SteamPacketFactory {
    public static SteamPacket getPacketFromData(byte[] rawData) throws PacketFormatException {
        byte header = rawData[0];
        byte[] data = new byte[rawData.length - 1];
        System.arraycopy(rawData, 1, data, 0, rawData.length - 1);
        switch (header) {
            case 84: {
                return new A2S_INFO_Packet();
            }
            case 109: {
                return new S2A_INFO_DETAILED_Packet(data);
            }
            case 73: {
                return new S2A_INFO2_Packet(data);
            }
            case 85: {
                return new A2S_PLAYER_Packet(Helper.integerFromByteArray(data));
            }
            case 68: {
                return new S2A_PLAYER_Packet(data);
            }
            case 86: {
                return new A2S_RULES_Packet(Helper.integerFromByteArray(data));
            }
            case 69: {
                return new S2A_RULES_Packet(data);
            }
            case 87: {
                return new A2S_SERVERQUERY_GETCHALLENGE_Packet();
            }
            case 65: {
                return new S2C_CHALLENGE_Packet(data);
            }
            case 102: {
                return new M2A_SERVER_BATCH_Paket(data);
            }
            case 78: {
                return new M2C_ISVALIDMD5_Packet(data);
            }
            case 79: {
                return new M2S_REQUESTRESTART_Packet(data);
            }
            case 57: 
            case 99: 
            case 108: {
                return new RCONGoldSrcResponsePacket(data);
            }
            case 82: {
                return new S2A_LOGSTRING_Packet(data);
            }
        }
        throw new PacketFormatException("Unknown packet with header 0x" + Integer.toHexString(header) + " received.");
    }

    public static SteamPacket reassemblePacket(ArrayList<byte[]> splitPackets) throws SteamCondenserException {
        return SteamPacketFactory.reassemblePacket(splitPackets, false, 0, 0);
    }

    public static SteamPacket reassemblePacket(ArrayList<byte[]> splitPackets, boolean isCompressed, int uncompressedSize, int packetChecksum) throws SteamCondenserException {
        byte[] tmpData;
        byte[] packetData = new byte[]{};
        for (byte[] splitPacket : splitPackets) {
            tmpData = packetData;
            packetData = new byte[tmpData.length + splitPacket.length];
            System.arraycopy(tmpData, 0, packetData, 0, tmpData.length);
            System.arraycopy(splitPacket, 0, packetData, tmpData.length, splitPacket.length);
        }
        if (isCompressed) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(packetData);
                stream.read();
                stream.read();
                BZip2CompressorInputStream bzip2 = new BZip2CompressorInputStream((InputStream)stream);
                byte[] uncompressedPacketData = new byte[uncompressedSize];
                bzip2.read(uncompressedPacketData, 0, uncompressedSize);
                CRC32 crc32 = new CRC32();
                crc32.update(uncompressedPacketData);
                int crc32checksum = (int)crc32.getValue();
                if (crc32checksum != packetChecksum) {
                    throw new PacketFormatException("CRC32 checksum mismatch of uncompressed packet data.");
                }
                packetData = uncompressedPacketData;
            }
            catch (IOException e) {
                throw new SteamCondenserException(e.getMessage(), e);
            }
        }
        tmpData = packetData;
        packetData = new byte[tmpData.length - 4];
        System.arraycopy(tmpData, 4, packetData, 0, tmpData.length - 4);
        return SteamPacketFactory.getPacketFromData(packetData);
    }
}

