/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.packets.rcon;

import com.github.koraktor.steamcondenser.PacketBuffer;
import com.github.koraktor.steamcondenser.exceptions.PacketFormatException;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONAuthResponse;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONExecResponsePacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONPacket;

public abstract class RCONPacketFactory {
    public static RCONPacket getPacketFromData(byte[] rawData) throws PacketFormatException {
        PacketBuffer packetBuffer = new PacketBuffer(rawData);
        int requestId = Integer.reverseBytes(packetBuffer.getInt());
        int header = Integer.reverseBytes(packetBuffer.getInt());
        String data = packetBuffer.getString();
        switch (header) {
            case 2: {
                return new RCONAuthResponse(requestId);
            }
            case 0: {
                return new RCONExecResponsePacket(requestId, data);
            }
        }
        throw new PacketFormatException("Unknown packet with header " + header + " received.");
    }
}

