/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.servers;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.SteamPlayer;
import com.github.koraktor.steamcondenser.steam.packets.A2S_INFO_Packet;
import com.github.koraktor.steamcondenser.steam.packets.A2S_PLAYER_Packet;
import com.github.koraktor.steamcondenser.steam.packets.A2S_RULES_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2A_INFO_BasePacket;
import com.github.koraktor.steamcondenser.steam.packets.S2A_PLAYER_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2A_RULES_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2C_CHALLENGE_Packet;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import com.github.koraktor.steamcondenser.steam.servers.Server;
import com.github.koraktor.steamcondenser.steam.sockets.QuerySocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GameServer
extends Server {
    protected static final int REQUEST_CHALLENGE = 0;
    protected static final int REQUEST_INFO = 1;
    protected static final int REQUEST_PLAYER = 2;
    protected static final int REQUEST_RULES = 3;
    protected int challengeNumber = -1;
    protected int ping;
    protected HashMap<String, SteamPlayer> playerHash;
    protected boolean rconAuthenticated = false;
    protected int rconRequestId;
    protected HashMap<String, String> rulesHash;
    protected HashMap<String, Object> serverInfo;
    protected QuerySocket socket;

    protected GameServer(Object address, Integer port) throws SteamCondenserException {
        super(address, port);
    }

    @Override
    public void disconnect() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    protected static List<String> getPlayerStatusAttributes(String statusHeader) {
        ArrayList<String> statusAttributes = new ArrayList<String>();
        for (String attribute : statusHeader.split("\\s+")) {
            if (attribute.equals("connected")) {
                statusAttributes.add("time");
                continue;
            }
            if (attribute.equals("frag")) {
                statusAttributes.add("score");
                continue;
            }
            statusAttributes.add(attribute);
        }
        return statusAttributes;
    }

    protected static Map<String, String> splitPlayerStatus(List<String> attributes, String playerStatus) {
        if (!attributes.get(0).equals("userid")) {
            playerStatus = playerStatus.replaceAll("^\\d+ +", "");
        }
        int firstQuote = playerStatus.indexOf(34);
        int lastQuote = playerStatus.lastIndexOf(34);
        ArrayList<String> tmpData = new ArrayList<String>();
        tmpData.add(playerStatus.substring(0, firstQuote));
        tmpData.add(playerStatus.substring(firstQuote + 1, lastQuote));
        tmpData.add(playerStatus.substring(lastQuote + 1));
        ArrayList<String> data = new ArrayList<String>();
        data.addAll(Arrays.asList(((String)tmpData.get(0)).trim().split("\\s+")));
        data.add((String)tmpData.get(1));
        data.addAll(Arrays.asList(((String)tmpData.get(2)).trim().split("\\s+")));
        data.remove("");
        if (attributes.size() > data.size() && attributes.contains("state")) {
            data.add(3, null);
            data.add(3, null);
            data.add(3, null);
        } else if (attributes.size() < data.size()) {
            data.remove(1);
        }
        HashMap<String, String> playerData = new HashMap<String, String>();
        for (int i = 0; i < data.size(); ++i) {
            playerData.put(attributes.get(i), (String)data.get(i));
        }
        return playerData;
    }

    public int getPing() throws SteamCondenserException, TimeoutException {
        if (this.ping == 0) {
            this.updatePing();
        }
        return this.ping;
    }

    public HashMap<String, SteamPlayer> getPlayers() throws SteamCondenserException, TimeoutException {
        return this.getPlayers(null);
    }

    public HashMap<String, SteamPlayer> getPlayers(String rconPassword) throws SteamCondenserException, TimeoutException {
        if (this.playerHash == null) {
            this.updatePlayers(rconPassword);
        }
        return this.playerHash;
    }

    public HashMap<String, String> getRules() throws SteamCondenserException, TimeoutException {
        if (this.rulesHash == null) {
            this.updateRules();
        }
        return this.rulesHash;
    }

    public HashMap<String, Object> getServerInfo() throws SteamCondenserException, TimeoutException {
        if (this.serverInfo == null) {
            this.updateServerInfo();
        }
        return this.serverInfo;
    }

    protected SteamPacket getReply() throws TimeoutException, SteamCondenserException {
        return this.socket.getReply();
    }

    protected void handleResponseForRequest(int requestType) throws SteamCondenserException, TimeoutException {
        this.handleResponseForRequest(requestType, true);
    }

    protected void handleResponseForRequest(int requestType, boolean repeatOnFailure) throws SteamCondenserException, TimeoutException {
        Class<SteamPacket> expectedResponse = SteamPacket.class;
        SteamPacket requestPacket = null;
        switch (requestType) {
            case 0: {
                expectedResponse = S2C_CHALLENGE_Packet.class;
                requestPacket = new A2S_PLAYER_Packet();
                break;
            }
            case 1: {
                expectedResponse = S2A_INFO_BasePacket.class;
                requestPacket = new A2S_INFO_Packet();
                break;
            }
            case 2: {
                expectedResponse = S2A_PLAYER_Packet.class;
                requestPacket = new A2S_PLAYER_Packet(this.challengeNumber);
                break;
            }
            case 3: {
                expectedResponse = S2A_RULES_Packet.class;
                requestPacket = new A2S_RULES_Packet(this.challengeNumber);
            }
        }
        this.sendRequest(requestPacket);
        SteamPacket responsePacket = this.getReply();
        if (S2A_INFO_BasePacket.class.isInstance(responsePacket)) {
            this.serverInfo = ((S2A_INFO_BasePacket)responsePacket).getInfo();
        } else if (responsePacket instanceof S2A_PLAYER_Packet) {
            this.playerHash = ((S2A_PLAYER_Packet)responsePacket).getPlayerHash();
        } else if (responsePacket instanceof S2A_RULES_Packet) {
            this.rulesHash = ((S2A_RULES_Packet)responsePacket).getRulesHash();
        } else if (responsePacket instanceof S2C_CHALLENGE_Packet) {
            this.challengeNumber = ((S2C_CHALLENGE_Packet)responsePacket).getChallengeNumber();
        } else {
            throw new SteamCondenserException("Response of type " + responsePacket.getClass() + " cannot be handled by this method.");
        }
        if (!expectedResponse.isInstance(responsePacket)) {
            Logger.getLogger("com.github.koraktor.steamcondenser").warning("Expected " + expectedResponse + ", got " + responsePacket.getClass() + ".");
            if (repeatOnFailure) {
                this.handleResponseForRequest(requestType, false);
            }
        }
    }

    public void initialize() throws SteamCondenserException, TimeoutException {
        this.updatePing();
        this.updateServerInfo();
        this.updateChallengeNumber();
    }

    public boolean isRconAuthenticated() {
        return this.rconAuthenticated;
    }

    public abstract boolean rconAuth(String var1) throws SteamCondenserException, TimeoutException;

    public abstract String rconExec(String var1) throws SteamCondenserException, TimeoutException;

    protected void sendRequest(SteamPacket requestData) throws SteamCondenserException {
        if (this.socket == null) {
            this.initSocket();
        }
        this.socket.send(requestData);
    }

    public String toString() {
        String returnString = "";
        returnString = returnString + "Ping: " + this.ping + "\n";
        returnString = returnString + "Challenge number: " + this.challengeNumber + "\n";
        if (this.serverInfo != null) {
            returnString = returnString + "Info:\n";
            for (Map.Entry entry : this.serverInfo.entrySet()) {
                returnString = returnString + "  " + (String)entry.getKey() + ": " + entry.getValue() + "\n";
            }
        }
        if (this.playerHash != null) {
            returnString = returnString + "Players:\n";
            for (SteamPlayer steamPlayer : this.playerHash.values()) {
                returnString = returnString + "  " + steamPlayer + "\n";
            }
        }
        if (this.rulesHash != null) {
            returnString = returnString + "Rules:\n";
            for (Map.Entry entry : this.rulesHash.entrySet()) {
                returnString = returnString + "  " + (String)entry.getKey() + ": " + (String)entry.getValue() + "\n";
            }
        }
        return returnString;
    }

    public void updateChallengeNumber() throws SteamCondenserException, TimeoutException {
        this.handleResponseForRequest(0);
    }

    public void updatePing() throws SteamCondenserException, TimeoutException {
        this.sendRequest(new A2S_INFO_Packet());
        long startTime = System.currentTimeMillis();
        this.getReply();
        long endTime = System.currentTimeMillis();
        this.ping = Long.valueOf(endTime - startTime).intValue();
    }

    public void updatePlayers() throws SteamCondenserException, TimeoutException {
        this.updatePlayers(null);
    }

    public void updatePlayers(String rconPassword) throws SteamCondenserException, TimeoutException {
        this.handleResponseForRequest(2);
        if (!this.rconAuthenticated) {
            if (rconPassword == null) {
                return;
            }
            this.rconAuth(rconPassword);
        }
        ArrayList<String> players = new ArrayList<String>();
        for (String line : Arrays.asList(this.rconExec("status").split("\n"))) {
            if (!line.startsWith("#") || line.equals("#end")) continue;
            players.add(line.substring(1).trim());
        }
        List<String> attributes = GameServer.getPlayerStatusAttributes((String)players.remove(0));
        for (String player : players) {
            Map<String, String> playerData = GameServer.splitPlayerStatus(attributes, player);
            String playerName = playerData.get("name");
            if (!this.playerHash.containsKey(playerName)) continue;
            this.playerHash.get(playerName).addInformation(playerData);
        }
    }

    public void updateRules() throws SteamCondenserException, TimeoutException {
        this.handleResponseForRequest(3);
    }

    public void updateServerInfo() throws SteamCondenserException, TimeoutException {
        this.handleResponseForRequest(1);
    }
}

