/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.servers;

import com.github.koraktor.steamcondenser.exceptions.RCONNoAuthException;
import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.servers.GameServer;
import com.github.koraktor.steamcondenser.steam.servers.MasterServer;
import com.github.koraktor.steamcondenser.steam.sockets.GoldSrcSocket;
import java.net.InetAddress;
import java.util.concurrent.TimeoutException;

public class GoldSrcServer
extends GameServer {
    private boolean isHLTV;
    protected String rconPassword;

    public static MasterServer getMaster() throws SteamCondenserException {
        return new MasterServer("hl1master.steampowered.com:27011");
    }

    public GoldSrcServer(String address) throws SteamCondenserException {
        this(address, (Integer)27015, false);
    }

    public GoldSrcServer(String address, Integer port) throws SteamCondenserException {
        this(address, port, false);
    }

    public GoldSrcServer(String address, Integer port, boolean isHLTV) throws SteamCondenserException {
        super(address, port);
        this.isHLTV = isHLTV;
    }

    public GoldSrcServer(InetAddress address) throws SteamCondenserException {
        this(address, (Integer)27015, false);
    }

    public GoldSrcServer(InetAddress address, Integer port) throws SteamCondenserException {
        this(address, port, false);
    }

    public GoldSrcServer(InetAddress address, Integer port, boolean isHLTV) throws SteamCondenserException {
        super(address, port);
        this.isHLTV = isHLTV;
    }

    public void initSocket() throws SteamCondenserException {
        this.socket = new GoldSrcSocket(this.ipAddress, this.port, this.isHLTV);
    }

    public boolean rconAuth(String password) throws SteamCondenserException, TimeoutException {
        this.rconPassword = password;
        try {
            this.rconAuthenticated = true;
            this.rconExec("");
        }
        catch (RCONNoAuthException e) {
            this.rconAuthenticated = false;
            this.rconPassword = null;
        }
        return this.rconAuthenticated;
    }

    public String rconExec(String command) throws TimeoutException, SteamCondenserException {
        if (!this.rconAuthenticated) {
            throw new RCONNoAuthException();
        }
        try {
            return ((GoldSrcSocket)this.socket).rconExec(this.rconPassword, command).trim();
        }
        catch (RCONNoAuthException e) {
            this.rconAuthenticated = false;
            throw e;
        }
    }
}

