/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.servers;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.A2M_GET_SERVERS_BATCH2_Paket;
import com.github.koraktor.steamcondenser.steam.packets.C2M_CHECKMD5_Packet;
import com.github.koraktor.steamcondenser.steam.packets.M2A_SERVER_BATCH_Paket;
import com.github.koraktor.steamcondenser.steam.packets.M2C_ISVALIDMD5_Packet;
import com.github.koraktor.steamcondenser.steam.packets.S2M_HEARTBEAT2_Packet;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import com.github.koraktor.steamcondenser.steam.servers.Server;
import com.github.koraktor.steamcondenser.steam.sockets.MasterServerSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterServer
extends Server {
    public static final String GOLDSRC_MASTER_SERVER = "hl1master.steampowered.com:27011";
    public static final String SOURCE_MASTER_SERVER = "hl2master.steampowered.com:27011";
    public static final byte REGION_US_EAST_COAST = 0;
    public static final byte REGION_US_WEST_COAST = 1;
    public static final byte REGION_SOUTH_AMERICA = 2;
    public static final byte REGION_EUROPE = 3;
    public static final byte REGION_ASIA = 4;
    public static final byte REGION_AUSTRALIA = 5;
    public static final byte REGION_MIDDLE_EAST = 6;
    public static final byte REGION_AFRICA = 7;
    public static final byte REGION_ALL = -1;
    public static int retries = 3;
    protected MasterServerSocket socket;

    public static void setRetries(int newRetries) {
        retries = newRetries;
    }

    public MasterServer(String address) throws SteamCondenserException {
        super(address, null);
    }

    public MasterServer(String address, Integer port) throws SteamCondenserException {
        super(address, port);
    }

    public MasterServer(InetAddress address) throws SteamCondenserException {
        super(address, null);
    }

    public MasterServer(InetAddress address, Integer port) throws SteamCondenserException {
        super(address, port);
    }

    public int getChallenge() throws SteamCondenserException, TimeoutException {
        this.socket.send(new C2M_CHECKMD5_Packet());
        return ((M2C_ISVALIDMD5_Packet)this.socket.getReply()).getChallenge();
    }

    public Vector<InetSocketAddress> getServers() throws SteamCondenserException, TimeoutException {
        return this.getServers((byte)-1, "", false);
    }

    public Vector<InetSocketAddress> getServers(byte regionCode, String filter) throws SteamCondenserException, TimeoutException {
        return this.getServers(regionCode, filter, false);
    }

    public Vector<InetSocketAddress> getServers(byte regionCode, String filter, boolean force) throws SteamCondenserException, TimeoutException {
        int failCount = 0;
        boolean finished = false;
        int portNumber = 0;
        String hostName = "0.0.0.0";
        Vector<InetSocketAddress> serverArray = new Vector<InetSocketAddress>();
        while (true) {
            try {
                failCount = 0;
                do {
                    this.socket.send(new A2M_GET_SERVERS_BATCH2_Paket(regionCode, hostName + ":" + portNumber, filter));
                    try {
                        Vector<String> serverStringArray = ((M2A_SERVER_BATCH_Paket)this.socket.getReply()).getServers();
                        for (String serverString : serverStringArray) {
                            hostName = serverString.substring(0, serverString.lastIndexOf(":"));
                            portNumber = Integer.valueOf(serverString.substring(serverString.lastIndexOf(":") + 1));
                            if (!hostName.equals("0.0.0.0") && portNumber != 0) {
                                serverArray.add(new InetSocketAddress(hostName, portNumber));
                                continue;
                            }
                            finished = true;
                        }
                        failCount = 0;
                    }
                    catch (TimeoutException e) {
                        if (++failCount == retries) {
                            throw e;
                        }
                        Logger.getLogger("com.github.koraktor.steamcondenser").info("Request to master server " + this.ipAddress + " timed out, retrying...");
                    }
                } while (!finished);
            }
            catch (TimeoutException e) {
                if (force) break;
                if (this.rotateIp()) {
                    throw e;
                }
                Logger.getLogger("com.github.koraktor.steamcondenser").info("Request to master server failed, retrying " + this.ipAddress + "...");
                continue;
            }
            break;
        }
        return serverArray;
    }

    @Override
    public void initSocket() throws SteamCondenserException {
        this.socket = new MasterServerSocket(this.ipAddress, this.port);
    }

    public List<SteamPacket> sendHeartbeat(Map<String, Object> data) throws SteamCondenserException {
        this.socket.send(new S2M_HEARTBEAT2_Packet(data));
        ArrayList<SteamPacket> replyPackets = new ArrayList<SteamPacket>();
        try {
            while (true) {
                replyPackets.add(this.socket.getReply());
            }
        }
        catch (TimeoutException timeoutException) {
            return replyPackets;
        }
    }
}

