/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.servers;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Server {
    protected List<String> hostNames = new ArrayList<String>();
    protected InetAddress ipAddress;
    protected List<InetAddress> ipAddresses = new ArrayList<InetAddress>();
    protected int ipIndex = 0;
    protected int port;

    protected Server(Object address, Integer port) throws SteamCondenserException {
        if (address instanceof String) {
            if (((String)address).indexOf(58) >= 0) {
                Object[] tmpAddress = ((String)address).split(":", 2);
                port = Integer.parseInt(tmpAddress[1]);
                address = tmpAddress[0];
            }
            if (port == null) {
                port = 27015;
            }
            try {
                for (InetAddress ipAddress : InetAddress.getAllByName((String)address)) {
                    this.hostNames.add(ipAddress.getHostName());
                    this.ipAddresses.add(ipAddress);
                }
            }
            catch (UnknownHostException e) {
                throw new SteamCondenserException("Cannot resolve " + address + ": " + e.getMessage());
            }
        } else if (address instanceof InetAddress) {
            this.hostNames.add(((InetAddress)address).getHostName());
            this.ipAddresses.add((InetAddress)address);
        }
        if (port == null) {
            throw new IllegalArgumentException("No port given");
        }
        this.ipAddress = this.ipAddresses.get(0);
        this.port = port;
        this.initSocket();
    }

    public void disconnect() {
    }

    public List<String> getHostNames() {
        return this.hostNames;
    }

    public List<InetAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public boolean rotateIp() throws SteamCondenserException {
        if (this.ipAddresses.size() == 1) {
            return true;
        }
        this.ipIndex = (this.ipIndex + 1) % this.ipAddresses.size();
        this.ipAddress = this.ipAddresses.get(this.ipIndex);
        this.initSocket();
        return this.ipIndex == 0;
    }

    protected void finalize() {
        this.disconnect();
    }

    protected abstract void initSocket() throws SteamCondenserException;
}

