/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.servers;

import com.github.koraktor.steamcondenser.exceptions.RCONBanException;
import com.github.koraktor.steamcondenser.exceptions.RCONNoAuthException;
import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONAuthRequestPacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONAuthResponse;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONExecRequestPacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONExecResponsePacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONPacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONTerminator;
import com.github.koraktor.steamcondenser.steam.servers.GameServer;
import com.github.koraktor.steamcondenser.steam.servers.MasterServer;
import com.github.koraktor.steamcondenser.steam.sockets.RCONSocket;
import com.github.koraktor.steamcondenser.steam.sockets.SourceSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;

public class SourceServer
extends GameServer {
    protected RCONSocket rconSocket;

    public static MasterServer getMaster() throws SteamCondenserException {
        return new MasterServer("hl2master.steampowered.com:27011");
    }

    public SourceServer(String address) throws SteamCondenserException {
        super(address, 27015);
    }

    public SourceServer(String address, Integer port) throws SteamCondenserException {
        super(address, port);
    }

    public SourceServer(InetAddress address) throws SteamCondenserException {
        super(address, 27015);
    }

    public SourceServer(InetAddress address, Integer port) throws SteamCondenserException {
        super(address, port);
    }

    public void disconnect() {
        super.disconnect();
        this.rconSocket.close();
    }

    public void initSocket() throws SteamCondenserException {
        this.rconSocket = new RCONSocket(this.ipAddress, this.port);
        this.socket = new SourceSocket(this.ipAddress, this.port);
    }

    public boolean rconAuth(String password) throws TimeoutException, SteamCondenserException {
        this.rconRequestId = new Random().nextInt();
        this.rconSocket.send(new RCONAuthRequestPacket(this.rconRequestId, password));
        RCONPacket reply = this.rconSocket.getReply();
        if (reply == null) {
            throw new RCONBanException();
        }
        reply = this.rconSocket.getReply();
        this.rconAuthenticated = reply.getRequestId() == this.rconRequestId;
        return this.rconAuthenticated;
    }

    public String rconExec(String command) throws TimeoutException, SteamCondenserException {
        if (!this.rconAuthenticated) {
            throw new RCONNoAuthException();
        }
        this.rconSocket.send(new RCONExecRequestPacket(this.rconRequestId, command));
        boolean isMulti = false;
        ArrayList<String> response = new ArrayList<String>();
        do {
            RCONPacket responsePacket;
            if ((responsePacket = this.rconSocket.getReply()) == null || responsePacket instanceof RCONAuthResponse) {
                this.rconAuthenticated = false;
                throw new RCONNoAuthException();
            }
            if (!isMulti && ((RCONExecResponsePacket)responsePacket).getResponse().length() > 0) {
                isMulti = true;
                this.rconSocket.send(new RCONTerminator(this.rconRequestId));
            }
            response.add(((RCONExecResponsePacket)responsePacket).getResponse());
        } while (isMulti && (response.size() <= 2 || !((String)response.get(response.size() - 2)).equals("") || !((String)response.get(response.size() - 1)).equals("")));
        return StringUtils.join((Object[])response.toArray()).trim();
    }
}

