/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.sockets;

import com.github.koraktor.steamcondenser.exceptions.RCONBanException;
import com.github.koraktor.steamcondenser.exceptions.RCONNoAuthException;
import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacketFactory;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONGoldSrcRequestPacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONGoldSrcResponsePacket;
import com.github.koraktor.steamcondenser.steam.sockets.QuerySocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class GoldSrcSocket
extends QuerySocket {
    protected boolean isHLTV;
    protected long rconChallenge = -1L;

    public GoldSrcSocket(InetAddress ipAddress, int portNumber) throws SteamCondenserException {
        super(ipAddress, portNumber);
        this.isHLTV = false;
    }

    public GoldSrcSocket(InetAddress ipAddress, int portNumber, boolean isHLTV) throws SteamCondenserException {
        super(ipAddress, portNumber);
        this.isHLTV = isHLTV;
    }

    public SteamPacket getReply() throws SteamCondenserException, TimeoutException {
        SteamPacket packet;
        int bytesRead = this.receivePacket(1400);
        if (this.packetIsSplit()) {
            ArrayList<byte[]> splitPackets = new ArrayList<byte[]>();
            do {
                int requestId = Integer.reverseBytes(this.buffer.getInt());
                byte packetNumberAndCount = this.buffer.get();
                int packetCount = packetNumberAndCount & 0xF;
                int packetNumber = (packetNumberAndCount >> 4) + 1;
                byte[] splitData = new byte[this.buffer.remaining()];
                this.buffer.get(splitData);
                splitPackets.ensureCapacity(packetCount);
                splitPackets.add(packetNumber - 1, splitData);
                Logger.getLogger("com.github.koraktor.steamcondenser").info("Received packet #" + packetNumber + " of " + packetCount + " for request ID " + requestId + ".");
                if (splitPackets.size() < packetCount) {
                    try {
                        bytesRead = this.receivePacket();
                    }
                    catch (TimeoutException e) {
                        bytesRead = 0;
                    }
                    continue;
                }
                bytesRead = 0;
            } while (bytesRead > 0 && this.packetIsSplit());
            packet = SteamPacketFactory.reassemblePacket(splitPackets);
        } else {
            packet = this.getPacketFromData();
        }
        Logger.getLogger("com.github.koraktor.steamcondenser").info("Received packet of type \"" + packet.getClass().getSimpleName() + "\"");
        return packet;
    }

    public String rconExec(String password, String command) throws TimeoutException, SteamCondenserException {
        String responsePart;
        String response;
        if (this.rconChallenge == -1L || this.isHLTV) {
            this.rconGetChallenge();
        }
        this.rconSend("rcon " + this.rconChallenge + " " + password + " " + command);
        if (this.isHLTV) {
            try {
                response = ((RCONGoldSrcResponsePacket)this.getReply()).getResponse();
            }
            catch (TimeoutException e) {
                response = "";
            }
        } else {
            response = ((RCONGoldSrcResponsePacket)this.getReply()).getResponse();
        }
        if (response.trim().equals("Bad rcon_password.")) {
            throw new RCONNoAuthException();
        }
        if (response.trim().equals("You have been banned from this server")) {
            throw new RCONBanException();
        }
        this.rconSend("rcon " + this.rconChallenge + " " + password);
        do {
            responsePart = ((RCONGoldSrcResponsePacket)this.getReply()).getResponse();
            response = response + responsePart;
        } while (responsePart.length() > 0);
        return response;
    }

    public void rconGetChallenge() throws SteamCondenserException, TimeoutException {
        this.rconSend("challenge rcon");
        String response = ((RCONGoldSrcResponsePacket)this.getReply()).getResponse().trim();
        if (response.equals("You have been banned from this server.")) {
            throw new RCONBanException();
        }
        this.rconChallenge = Long.valueOf(response.substring(14));
    }

    protected void rconSend(String command) throws SteamCondenserException {
        this.send(new RCONGoldSrcRequestPacket(command));
    }
}

