/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.sockets;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import com.github.koraktor.steamcondenser.steam.sockets.SteamSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public abstract class QuerySocket
extends SteamSocket {
    protected QuerySocket(InetAddress ipAddress, int portNumber) throws SteamCondenserException {
        super(ipAddress, portNumber);
        try {
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            ((DatagramChannel)this.channel).connect(this.remoteSocket);
        }
        catch (IOException e) {
            throw new SteamCondenserException(e.getMessage(), e);
        }
    }

    protected boolean packetIsSplit() {
        return Integer.reverseBytes(this.buffer.getInt()) == -2;
    }

    protected int receivePacket() throws SteamCondenserException, TimeoutException {
        return this.receivePacket(0);
    }

    public void send(SteamPacket dataPacket) throws SteamCondenserException {
        Logger.getLogger("com.github.koraktor.steamcondenser").info("Sending data packet of type \"" + dataPacket.getClass().getSimpleName() + "\"");
        try {
            this.buffer = ByteBuffer.wrap(dataPacket.getBytes());
            ((DatagramChannel)this.channel).send(this.buffer, this.remoteSocket);
            this.buffer.flip();
        }
        catch (IOException e) {
            throw new SteamCondenserException(e.getMessage(), e);
        }
    }
}

