/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.sockets;

import com.github.koraktor.steamcondenser.exceptions.ConnectionResetException;
import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONPacket;
import com.github.koraktor.steamcondenser.steam.packets.rcon.RCONPacketFactory;
import com.github.koraktor.steamcondenser.steam.sockets.SteamSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class RCONSocket
extends SteamSocket {
    protected static final Logger LOG = Logger.getLogger(RCONSocket.class.getName());

    public RCONSocket(InetAddress ipAddress, int portNumber) {
        super(ipAddress, portNumber);
    }

    public void close() {
        if (this.channel != null && ((SocketChannel)this.channel).isConnected()) {
            super.close();
        }
    }

    public void send(RCONPacket dataPacket) throws SteamCondenserException {
        try {
            if (this.channel == null || !((SocketChannel)this.channel).isConnected()) {
                this.channel = SocketChannel.open();
                ((SocketChannel)this.channel).socket().connect(this.remoteSocket, SteamSocket.timeout);
                this.channel.configureBlocking(false);
            }
            this.buffer = ByteBuffer.wrap(dataPacket.getBytes());
            ((SocketChannel)this.channel).write(this.buffer);
        }
        catch (IOException e) {
            throw new SteamCondenserException(e.getMessage(), e);
        }
    }

    public RCONPacket getReply() throws SteamCondenserException, TimeoutException {
        int receivedBytes;
        int packetSize;
        block7: {
            try {
                if (this.receivePacket(4) != 0) break block7;
                try {
                    this.channel.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return null;
            }
            catch (ConnectionResetException e) {
                try {
                    this.channel.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return null;
            }
        }
        int remainingBytes = packetSize = Integer.reverseBytes(this.buffer.getInt());
        byte[] packetData = new byte[packetSize];
        do {
            receivedBytes = this.receivePacket(remainingBytes);
            System.arraycopy(this.buffer.array(), 0, packetData, packetSize - remainingBytes, receivedBytes);
        } while ((remainingBytes -= receivedBytes) > 0);
        RCONPacket packet = RCONPacketFactory.getPacketFromData(packetData);
        LOG.info("Received packet of type \"" + packet.getClass() + "\".");
        return packet;
    }
}

