/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.sockets;

import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacketFactory;
import com.github.koraktor.steamcondenser.steam.sockets.QuerySocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class SourceSocket
extends QuerySocket {
    public SourceSocket(InetAddress ipAddress, int portNumber) throws SteamCondenserException {
        super(ipAddress, portNumber);
    }

    public SteamPacket getReply() throws SteamCondenserException, TimeoutException {
        SteamPacket packet;
        boolean isCompressed = false;
        int bytesRead = this.receivePacket(1400);
        if (this.packetIsSplit()) {
            int splitSize;
            int packetChecksum = 0;
            ArrayList<byte[]> splitPackets = new ArrayList<byte[]>();
            do {
                int requestId;
                isCompressed = ((requestId = Integer.reverseBytes(this.buffer.getInt())) & Integer.MIN_VALUE) != 0;
                byte packetCount = this.buffer.get();
                int packetNumber = this.buffer.get() + 1;
                if (isCompressed) {
                    splitSize = Integer.reverseBytes(this.buffer.getInt());
                    packetChecksum = Integer.reverseBytes(this.buffer.getInt());
                } else {
                    splitSize = Short.reverseBytes(this.buffer.getShort());
                }
                byte[] splitData = new byte[Math.min(splitSize, this.buffer.remaining())];
                this.buffer.get(splitData);
                splitPackets.ensureCapacity(packetCount);
                splitPackets.add(packetNumber - 1, splitData);
                if (splitPackets.size() < packetCount) {
                    try {
                        bytesRead = this.receivePacket();
                    }
                    catch (TimeoutException e) {
                        bytesRead = 0;
                    }
                } else {
                    bytesRead = 0;
                }
                Logger.getLogger("com.github.koraktor.steamcondenser").info("Received packet #" + packetNumber + " of " + packetCount + " for request ID " + requestId + ".");
            } while (bytesRead > 0 && this.packetIsSplit());
            packet = isCompressed ? SteamPacketFactory.reassemblePacket(splitPackets, true, splitSize, packetChecksum) : SteamPacketFactory.reassemblePacket(splitPackets);
        } else {
            packet = this.getPacketFromData();
        }
        this.buffer.flip();
        if (isCompressed) {
            Logger.getLogger("com.github.koraktor.steamcondenser").info("Received compressed reply of type \"" + packet.getClass().getSimpleName() + "\"");
        } else {
            Logger.getLogger("com.github.koraktor.steamcondenser").info("Received reply of type \"" + packet.getClass().getSimpleName() + "\"");
        }
        return packet;
    }
}

