/*
 * Decompiled with CFR 0.152.
 */
package com.github.koraktor.steamcondenser.steam.sockets;

import com.github.koraktor.steamcondenser.exceptions.ConnectionResetException;
import com.github.koraktor.steamcondenser.exceptions.PacketFormatException;
import com.github.koraktor.steamcondenser.exceptions.SteamCondenserException;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacket;
import com.github.koraktor.steamcondenser.steam.packets.SteamPacketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.concurrent.TimeoutException;

public abstract class SteamSocket {
    protected static int timeout = 1000;
    protected ByteBuffer buffer = ByteBuffer.allocate(1400);
    protected SelectableChannel channel;
    protected InetSocketAddress remoteSocket;

    public static void setTimeout(int timeout) {
        SteamSocket.timeout = timeout;
    }

    protected SteamSocket(InetAddress ipAddress, int portNumber) {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.remoteSocket = new InetSocketAddress(ipAddress, portNumber);
    }

    protected SteamPacket getPacketFromData() throws PacketFormatException {
        byte[] packetData = new byte[this.buffer.remaining()];
        this.buffer.get(packetData);
        return SteamPacketFactory.getPacketFromData(packetData);
    }

    public abstract SteamPacket getReply() throws SteamCondenserException, TimeoutException;

    protected int receivePacket(int bufferLength) throws SteamCondenserException, TimeoutException {
        Selector selector = null;
        try {
            selector = Selector.open();
            this.channel.register(selector, 1);
            if (selector.select(timeout) == 0) {
                throw new TimeoutException();
            }
            if (bufferLength == 0) {
                this.buffer.clear();
            } else {
                this.buffer = ByteBuffer.allocate(bufferLength);
            }
            int bytesRead = ((ReadableByteChannel)((Object)this.channel)).read(this.buffer);
            if (bytesRead < 0) {
                bytesRead = 0;
            }
            this.buffer.rewind();
            this.buffer.limit(bytesRead);
            int n = bytesRead;
            return n;
        }
        catch (IOException e) {
            if ("Connection reset by peer".equals(e.getMessage())) {
                throw new ConnectionResetException();
            }
            throw new SteamCondenserException(e.getMessage(), e);
        }
        finally {
            if (selector != null) {
                try {
                    selector.close();
                }
                catch (IOException e) {
                    throw new SteamCondenserException(e.getMessage(), e);
                }
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

