/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.zipkin;

import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.zipkin.SpanProcessingThread;
import com.github.kristofa.brave.zipkin.ZipkinCollectorClientProvider;
import com.github.kristofa.brave.zipkin.ZipkinSpanCollectorParams;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Span;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TException;

public class ZipkinSpanCollector
implements SpanCollector,
Closeable {
    private static final String UTF_8 = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(ZipkinSpanCollector.class.getName());
    private final BlockingQueue<Span> spanQueue;
    private final ExecutorService executorService;
    private final List<SpanProcessingThread> spanProcessingThreads = new ArrayList<SpanProcessingThread>();
    private final List<ZipkinCollectorClientProvider> clientProviders = new ArrayList<ZipkinCollectorClientProvider>();
    private final List<Future<Integer>> futures = new ArrayList<Future<Integer>>();
    private final Set<BinaryAnnotation> defaultAnnotations = new HashSet<BinaryAnnotation>();

    public ZipkinSpanCollector(String zipkinCollectorHost, int zipkinCollectorPort) {
        this(zipkinCollectorHost, zipkinCollectorPort, new ZipkinSpanCollectorParams());
    }

    public ZipkinSpanCollector(String zipkinCollectorHost, int zipkinCollectorPort, ZipkinSpanCollectorParams params) {
        Util.checkNotBlank((String)zipkinCollectorHost, (String)"Null or empty zipkinCollectorHost", (Object[])new Object[0]);
        Util.checkNotNull((Object)params, (String)"Null params", (Object[])new Object[0]);
        this.spanQueue = new ArrayBlockingQueue<Span>(params.getQueueSize());
        this.executorService = Executors.newFixedThreadPool(params.getNrOfThreads());
        for (int i = 1; i <= params.getNrOfThreads(); ++i) {
            ZipkinCollectorClientProvider clientProvider = this.createZipkinCollectorClientProvider(zipkinCollectorHost, zipkinCollectorPort, params);
            SpanProcessingThread spanProcessingThread = new SpanProcessingThread(this.spanQueue, clientProvider, params.getBatchSize());
            this.spanProcessingThreads.add(spanProcessingThread);
            this.clientProviders.add(clientProvider);
            this.futures.add(this.executorService.submit(spanProcessingThread));
        }
    }

    private ZipkinCollectorClientProvider createZipkinCollectorClientProvider(String zipkinCollectorHost, int zipkinCollectorPort, ZipkinSpanCollectorParams params) {
        ZipkinCollectorClientProvider clientProvider = new ZipkinCollectorClientProvider(zipkinCollectorHost, zipkinCollectorPort, params.getSocketTimeout());
        try {
            clientProvider.setup();
        }
        catch (TException e) {
            if (params.failOnSetup()) {
                throw new IllegalStateException(e);
            }
            LOGGER.log(Level.WARNING, "Connection could not be established during setup.", e);
        }
        return clientProvider;
    }

    public void collect(Span span) {
        boolean offer;
        long start = System.currentTimeMillis();
        if (!this.defaultAnnotations.isEmpty()) {
            for (BinaryAnnotation ba : this.defaultAnnotations) {
                span.addToBinary_annotations(ba);
            }
        }
        if (!(offer = this.spanQueue.offer(span))) {
            LOGGER.warning("Queue rejected Span, span not submitted: " + span);
        } else {
            long end = System.currentTimeMillis();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding span to queue took " + (end - start) + "ms.");
            }
        }
    }

    public void addDefaultAnnotation(String key, String value) {
        Util.checkNotBlank((String)key, (String)"Null or blank key", (Object[])new Object[0]);
        Util.checkNotNull((Object)value, (String)"Null value", (Object[])new Object[0]);
        try {
            ByteBuffer bb = ByteBuffer.wrap(value.getBytes(UTF_8));
            BinaryAnnotation binaryAnnotation = new BinaryAnnotation();
            binaryAnnotation.setKey(key);
            binaryAnnotation.setValue(bb);
            binaryAnnotation.setAnnotation_type(AnnotationType.STRING);
            this.defaultAnnotations.add(binaryAnnotation);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        LOGGER.info("Stopping SpanProcessingThread.");
        for (SpanProcessingThread spanProcessingThread : this.spanProcessingThreads) {
            spanProcessingThread.stop();
        }
        for (Future future : this.futures) {
            try {
                Integer spansProcessed = (Integer)future.get();
                LOGGER.info("SpanProcessingThread processed " + spansProcessed + "spans.");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception when getting result of SpanProcessingThread.", e);
            }
        }
        for (ZipkinCollectorClientProvider zipkinCollectorClientProvider : this.clientProviders) {
            zipkinCollectorClientProvider.close();
        }
        this.executorService.shutdown();
        LOGGER.info("ZipkinSpanCollector closed.");
    }
}

