/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.flume;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.github.kristofa.flume.HistogramBuilder;
import java.io.Closeable;
import org.apache.commons.lang.Validate;

class MetricReporter
implements Closeable {
    private final MetricRegistry metricRegistry;
    private final ScheduledReporter reporter;
    private final HistogramBuilder histogramBuilder;

    public MetricReporter(MetricRegistry metricRegistry, ScheduledReporter reporter, HistogramBuilder histogramBuilder) {
        Validate.notNull((Object)metricRegistry);
        Validate.notNull((Object)reporter);
        this.metricRegistry = metricRegistry;
        this.reporter = reporter;
        this.histogramBuilder = histogramBuilder;
    }

    public void update(String name, long value) {
        Histogram histogram = this.getHistogram(name);
        histogram.update(value);
    }

    @Override
    public void close() {
        this.reporter.close();
    }

    private Histogram getHistogram(String name) {
        Histogram histogram = (Histogram)this.metricRegistry.getHistograms().get(name);
        if (histogram == null) {
            histogram = this.histogramBuilder.buildHistogram();
            this.metricRegistry.register(name, (Metric)histogram);
        }
        return histogram;
    }
}

