/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.flume;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.github.kristofa.flume.ExponentiallyDecayingHistogramBuilder;
import com.github.kristofa.flume.HistogramBuilder;
import com.github.kristofa.flume.MetricReporter;
import com.github.kristofa.flume.SlidingTimeWindowHistogramBuilder;
import com.github.kristofa.flume.SlidingWindowHistogramBuilder;
import com.github.kristofa.flume.UniformHistogramBuilder;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricReporterBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricReporterBuilder.class);
    private static final String UNIFORM_RESERVOIR = "uniform";
    private static final String NR_OF_SAMPLES = "nrofsamples";
    private static final String EXPONENTIALLY_DECAYING_RESERVOIR = "exponentiallydecaying";
    private static final String DECAY_FACTOR = "decayfactor";
    private static final String SLIDING_TIME_WINDOW_RESERVOIR = "slidingtimewindow";
    private static final String WINDOW_IN_SECONDS = "windowseconds";
    private static final String SLIDING_WINDOW_RESERVOIR = "slidingwindow";
    private static final String DEFAULT_RESERVOIR = "uniform";
    private static final String GRAPHITE_HOST = "graphitehost";
    private static final String GRAPHITE_PORT = "graphiteport";
    private static final String METRICS_RESERVOIR = "reservoir";
    private static final String METRIC_PREFIX = "metricprefix";
    private static final String POLL_TIME = "polltime";
    private boolean succcesfulConfigured = false;
    private String graphiteHost;
    private Integer graphitePort;
    private String metricPrefix;
    private int pollTimeMinutes;
    private HistogramBuilder histogramBuilder;

    MetricReporterBuilder() {
    }

    public void configure(Context context) {
        this.succcesfulConfigured = false;
        this.graphiteHost = context.getString(GRAPHITE_HOST);
        this.graphitePort = context.getInteger(GRAPHITE_PORT);
        if (this.graphiteHost == null || this.graphitePort == null) {
            throw new IllegalStateException("graphitehost and graphiteport properties are mandatory.");
        }
        LOGGER.info("Graphite host: {}", (Object)this.graphiteHost);
        LOGGER.info("Graphite port: {}", (Object)this.graphitePort);
        this.metricPrefix = context.getString(METRIC_PREFIX);
        this.pollTimeMinutes = context.getInteger(POLL_TIME, Integer.valueOf(1));
        LOGGER.info("Reporter poll time in minutes: {}", (Object)this.pollTimeMinutes);
        String reservoir = context.getString(METRICS_RESERVOIR, "uniform");
        if ("uniform".equals(reservoir)) {
            LOGGER.info("Reservoir: {}", (Object)"uniform");
            this.initializeUniformHistogramBuilder(context);
        } else if (EXPONENTIALLY_DECAYING_RESERVOIR.equals(reservoir)) {
            LOGGER.info("Reservoir: {}", (Object)EXPONENTIALLY_DECAYING_RESERVOIR);
            this.initializeExponentiallyDecayingReservoir(context);
        } else if (SLIDING_TIME_WINDOW_RESERVOIR.equals(reservoir)) {
            LOGGER.info("Reservoir: {}", (Object)SLIDING_TIME_WINDOW_RESERVOIR);
            this.initializeSlidingTimeWindowReservoir(context);
        } else if (SLIDING_WINDOW_RESERVOIR.equals(reservoir)) {
            LOGGER.info("Reservoir: {}", (Object)SLIDING_WINDOW_RESERVOIR);
            this.initializeSlidingWindowReservoir(context);
        } else {
            throw new IllegalStateException("Invalid value for reservoir: " + reservoir);
        }
        this.succcesfulConfigured = true;
    }

    public MetricReporter build() {
        if (!this.succcesfulConfigured) {
            throw new IllegalStateException("MetricReporterBuilder is not successfully configured.");
        }
        MetricRegistry metricRegistry = new MetricRegistry();
        Graphite graphite = new Graphite(new InetSocketAddress(this.graphiteHost, (int)this.graphitePort));
        GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL);
        if (StringUtils.isNotBlank((String)this.metricPrefix)) {
            LOGGER.info("Metric prefix: {}", (Object)this.metricPrefix);
            builder.prefixedWith(this.metricPrefix);
        }
        GraphiteReporter reporter = builder.build(graphite);
        reporter.start((long)this.pollTimeMinutes, TimeUnit.MINUTES);
        return new MetricReporter(metricRegistry, (ScheduledReporter)reporter, this.histogramBuilder);
    }

    private void initializeUniformHistogramBuilder(Context context) {
        Integer nrOfSamples = context.getInteger(NR_OF_SAMPLES);
        this.histogramBuilder = nrOfSamples == null ? new UniformHistogramBuilder() : new UniformHistogramBuilder(nrOfSamples);
    }

    private void initializeExponentiallyDecayingReservoir(Context context) {
        Integer nrOfSamples = context.getInteger(NR_OF_SAMPLES);
        String decayFactorAsString = context.getString(DECAY_FACTOR);
        if (nrOfSamples != null && decayFactorAsString != null) {
            Double decayFactor = Double.valueOf(decayFactorAsString);
            this.histogramBuilder = new ExponentiallyDecayingHistogramBuilder(nrOfSamples, decayFactor);
        } else {
            this.histogramBuilder = new ExponentiallyDecayingHistogramBuilder();
        }
    }

    private void initializeSlidingTimeWindowReservoir(Context context) {
        Integer windowInSeconds = context.getInteger(WINDOW_IN_SECONDS);
        if (windowInSeconds == null) {
            throw new IllegalStateException("slidingtimewindow configuration needs mandatory windowseconds config entry.");
        }
        this.histogramBuilder = new SlidingTimeWindowHistogramBuilder(windowInSeconds.intValue());
    }

    private void initializeSlidingWindowReservoir(Context context) {
        Integer nrOfMeasurements = context.getInteger(NR_OF_SAMPLES);
        if (nrOfMeasurements == null) {
            throw new IllegalStateException("slidingwindow configuration needs mandatory nrofsamples config entry.");
        }
        this.histogramBuilder = new SlidingWindowHistogramBuilder(nrOfMeasurements);
    }
}

