/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestFileReader;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.Method;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

class HttpRequestFileReaderImpl
implements HttpRequestFileReader {
    private static final String QUERY_PARAMETERS = "[QueryParameters]";
    private static final String PATH = "[Path]";
    private static final String HTTP_MESSAGE_HEADER = "[HttpMessageHeader]";
    private static final String METHOD = "[Method]";

    HttpRequestFileReaderImpl() {
    }

    @Override
    public HttpRequest read(File httpRequestFile, File httpRequestEntityFile) {
        HttpRequestImpl httpRequestImpl = new HttpRequestImpl();
        try {
            this.readRequest(httpRequestImpl, httpRequestFile, httpRequestEntityFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return httpRequestImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRequest(HttpRequestImpl request, File requestFile, File requestEntityFile) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(requestFile), "UTF-8"));
        try {
            this.readNextLine(reader, METHOD);
            String method = reader.readLine();
            request.method(Method.valueOf(method));
            this.readNextLine(reader, HTTP_MESSAGE_HEADER);
            ArrayList<KeyValuePair> httpMessageHeaderValues = new ArrayList<KeyValuePair>();
            String nextSection = this.readKeyValuePairs(reader, httpMessageHeaderValues);
            if (!PATH.equals(nextSection)) {
                throw new IllegalStateException("Expected [Path] after [HttpMessageHeader] but got " + nextSection);
            }
            for (KeyValuePair keyValuePair : httpMessageHeaderValues) {
                request.httpMessageHeader(keyValuePair.key, keyValuePair.value);
            }
            String path = reader.readLine();
            request.path(path);
            this.readNextLine(reader, QUERY_PARAMETERS);
            ArrayList<KeyValuePair> queryParams = new ArrayList<KeyValuePair>();
            String nextSection2 = this.readKeyValuePairs(reader, queryParams);
            if (nextSection2 != null) {
                throw new IllegalStateException("Expected nothing after [QueryParameters] but got " + nextSection2);
            }
            for (KeyValuePair keyValuePair : queryParams) {
                request.queryParameter(keyValuePair.key, keyValuePair.value);
            }
            if (requestEntityFile.exists()) {
                byte[] entity = FileUtils.readFileToByteArray((File)requestEntityFile);
                request.content(entity);
            }
        }
        finally {
            reader.close();
        }
    }

    private String readNextLine(BufferedReader reader, String expectedValue) throws IOException {
        String value = reader.readLine();
        if (!expectedValue.equals(value)) {
            throw new IllegalStateException("Unexpected value. Expected " + expectedValue + " but was " + value);
        }
        return value;
    }

    private String readKeyValuePairs(BufferedReader reader, List<KeyValuePair> properties) throws IOException {
        String newLine = null;
        while ((newLine = reader.readLine()) != null) {
            if (newLine.indexOf("=") != -1) {
                String[] split = newLine.split("=");
                KeyValuePair pair = new KeyValuePair();
                if (split.length == 2) {
                    pair.key = split[0];
                    pair.value = split[1];
                } else {
                    pair.key = split[0];
                    pair.value = "";
                }
                properties.add(pair);
                continue;
            }
            return newLine;
        }
        return null;
    }

    private class KeyValuePair {
        public String key;
        public String value;

        private KeyValuePair() {
        }
    }
}

