/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpMessageHeaderField;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseImpl;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleHttpResponseProvider
implements HttpResponseProvider {
    private HttpRequestImpl latestRequest;
    private final Map<HttpRequest, HttpResponse> expectedRequests = new HashMap<HttpRequest, HttpResponse>();
    private final Set<HttpRequest> receivedRequests = new HashSet<HttpRequest>();

    public SimpleHttpResponseProvider expect(Method method, String path, String contentType, String data) {
        this.latestRequest = new HttpRequestImpl();
        this.latestRequest.method(method).path(path).content(data.getBytes()).httpMessageHeader(HttpMessageHeaderField.CONTENTTYPE.getValue(), contentType);
        return this;
    }

    public SimpleHttpResponseProvider expect(Method method, String path) {
        this.latestRequest = new HttpRequestImpl();
        this.latestRequest.method(method).path(path);
        return this;
    }

    public SimpleHttpResponseProvider respondWith(int httpCode, String contentType, String data) {
        HttpResponseImpl response = new HttpResponseImpl(httpCode, contentType, data == null ? null : data.getBytes());
        this.expectedRequests.put(this.latestRequest, response);
        return this;
    }

    @Override
    public HttpResponse getResponse(HttpRequest request) {
        this.receivedRequests.add(request);
        return this.expectedRequests.get(request);
    }

    @Override
    public void verify() throws UnsatisfiedExpectationException {
        if (!((Object)this.expectedRequests.keySet()).equals(this.receivedRequests)) {
            HashSet<HttpRequest> missing = new HashSet<HttpRequest>();
            for (HttpRequest expectedRequest : this.expectedRequests.keySet()) {
                if (this.receivedRequests.contains(expectedRequest)) continue;
                missing.add(expectedRequest);
            }
            HashSet<HttpRequest> unexpected = new HashSet<HttpRequest>();
            for (HttpRequest receivedRequest : this.receivedRequests) {
                if (this.expectedRequests.keySet().contains(receivedRequest)) continue;
                unexpected.add(receivedRequest);
            }
            throw new UnsatisfiedExpectationException(missing, unexpected);
        }
    }
}

