/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseFileReader;
import com.github.kristofa.test.http.HttpResponseImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.FileUtils;

class HttpResponseFileReaderImpl
implements HttpResponseFileReader {
    private static final String HTTPCODE = "[HttpCode]";
    private static final String CONTENTTYPE = "[ContentType]";

    HttpResponseFileReaderImpl() {
    }

    @Override
    public HttpResponse read(File httpResponseFile, File httpResponseEntityFile) {
        try {
            return this.readResponse(httpResponseFile, httpResponseEntityFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse readResponse(File httpResponseFile, File httpResponseEntityFile) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(httpResponseFile), "UTF-8"));
        try {
            this.readNextLine(reader, HTTPCODE);
            int httpCode = Integer.valueOf(reader.readLine());
            this.readNextLine(reader, CONTENTTYPE);
            String contentType = reader.readLine();
            byte[] entity = null;
            if (httpResponseEntityFile.exists()) {
                entity = FileUtils.readFileToByteArray((File)httpResponseEntityFile);
            }
            HttpResponseImpl httpResponseImpl = new HttpResponseImpl(httpCode, contentType, entity);
            return httpResponseImpl;
        }
        finally {
            reader.close();
        }
    }

    private String readNextLine(BufferedReader reader, String expectedValue) throws IOException {
        String value = reader.readLine();
        if (!expectedValue.equals(value)) {
            throw new IllegalStateException("Unexpected value. Expected " + expectedValue + " but was " + value);
        }
        return value;
    }
}

