/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.ForwardHttpRequestBuilder;
import com.github.kristofa.test.http.FullHttpRequest;
import com.github.kristofa.test.http.FullHttpRequestImpl;
import com.github.kristofa.test.http.HttpMessageHeaderField;
import com.github.kristofa.test.http.HttpRequestResponseLogger;
import com.github.kristofa.test.http.HttpRequestResponseLoggerFactory;
import com.github.kristofa.test.http.HttpResponseImpl;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.client.ApacheHttpClientImpl;
import com.github.kristofa.test.http.client.HttpClientResponse;
import com.github.kristofa.test.http.client.HttpRequestException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHttpProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingHttpProxy.class);
    private final int port;
    private final Collection<ForwardHttpRequestBuilder> requestBuilders = new HashSet<ForwardHttpRequestBuilder>();
    private final HttpRequestResponseLoggerFactory loggerFactory;
    private Connection connection;
    private ProxyImplementation proxy;

    public LoggingHttpProxy(int port, Collection<ForwardHttpRequestBuilder> requestBuilders, HttpRequestResponseLoggerFactory loggerFactory) {
        Validate.isTrue((requestBuilders != null && !requestBuilders.isEmpty() ? 1 : 0) != 0, (String)"At least 1 ForwardHttpRequestBuilder should be provided.", (Object[])new Object[0]);
        Validate.notNull((Object)loggerFactory, (String)"HttpRequestResponseLoggerFactory should not be null.", (Object[])new Object[0]);
        this.port = port;
        this.requestBuilders.addAll(requestBuilders);
        this.loggerFactory = loggerFactory;
    }

    public void start() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.proxy = new ProxyImplementation();
        this.connection = new SocketConnection((Container)this.proxy);
        InetSocketAddress address = new InetSocketAddress(this.port);
        this.connection.connect((SocketAddress)address);
        LOGGER.debug("Started on port: " + this.port);
    }

    public void stop() throws IOException {
        LOGGER.debug("Stopping and closing connection.");
        this.connection.close();
    }

    private class ProxyImplementation
    implements Container {
        private static final int UNKNOWN_EXCEPTION_HTTP_CODE = 573;
        private static final int FORWARD_REQUEST_FAILED_HTTP_CODE = 571;
        private static final int COPY_RESPONSE_FAILED_ERROR_HTTP_CODE = 572;
        private static final int NO_FORWARD_REQUEST_ERROR_HTTP_CODE = 570;
        private static final String CONTENT_TYPE = "Content-Type";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Request request, Response response) {
            block11: {
                try {
                    ForwardHttpRequestBuilder forwardRequestBuilder;
                    FullHttpRequestImpl httpRequest = this.buildHttpRequest(request);
                    FullHttpRequest forwardHttpRequest = null;
                    Iterator i$ = LoggingHttpProxy.this.requestBuilders.iterator();
                    while (i$.hasNext() && (forwardHttpRequest = (forwardRequestBuilder = (ForwardHttpRequestBuilder)i$.next()).getForwardRequest(httpRequest)) == null) {
                    }
                    if (forwardHttpRequest == null) {
                        this.errorResponse(response, 570, "Received unexpected request:\n" + httpRequest.toString());
                        break block11;
                    }
                    HttpRequestResponseLogger logger = LoggingHttpProxy.this.loggerFactory.getHttpRequestResponseLogger();
                    logger.log(httpRequest);
                    try {
                        HttpClientResponse<InputStream> forwardResponse = this.forward(forwardHttpRequest);
                        try {
                            InputStream inputStream = forwardResponse.getResponseEntity();
                            byte[] responseEntity = IOUtils.toByteArray((InputStream)inputStream);
                            inputStream.close();
                            HttpResponseImpl httpResponse = new HttpResponseImpl(forwardResponse.getHttpCode(), forwardResponse.getContentType(), responseEntity);
                            logger.log(httpResponse);
                            response.setCode(forwardResponse.getHttpCode());
                            response.set(CONTENT_TYPE, forwardResponse.getContentType());
                            OutputStream outputStream = response.getOutputStream();
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseEntity);
                            IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
                            byteArrayInputStream.close();
                            outputStream.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("IOException when trying to copy response of forward request.", (Throwable)e);
                            this.errorResponse(response, 572, "Exception when copying streams." + e.getMessage());
                        }
                        finally {
                            forwardResponse.close();
                        }
                    }
                    catch (HttpRequestException e) {
                        LOGGER.error("HttpRequestException when forwarding request.", (Throwable)e);
                        this.errorResponse(response, 571, "Exception when forwarding request." + e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception.", (Throwable)e);
                    this.errorResponse(response, 573, "Exception: " + e.getMessage());
                }
            }
        }

        private FullHttpRequestImpl buildHttpRequest(Request request) {
            byte[] data = null;
            try {
                if (request.getContentLength() > 0) {
                    InputStream inputStream = request.getInputStream();
                    data = IOUtils.toByteArray((InputStream)inputStream);
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception when getting request content.", e);
            }
            FullHttpRequestImpl httpRequestImpl = new FullHttpRequestImpl();
            httpRequestImpl.method(Method.valueOf(request.getMethod()));
            httpRequestImpl.path(request.getPath().getPath());
            httpRequestImpl.content(data);
            for (String headerField : request.getNames()) {
                if (!HttpMessageHeaderField.CONTENTTYPE.getValue().equals(headerField)) continue;
                for (String headerFieldValue : request.getValues(headerField)) {
                    httpRequestImpl.httpMessageHeader(headerField, headerFieldValue);
                }
            }
            httpRequestImpl.domain(null);
            httpRequestImpl.port(null);
            for (Map.Entry entry : request.getQuery().entrySet()) {
                httpRequestImpl.queryParameter((String)entry.getKey(), (String)entry.getValue());
            }
            return httpRequestImpl;
        }

        private HttpClientResponse<InputStream> forward(FullHttpRequest request) throws HttpRequestException {
            ApacheHttpClientImpl client = new ApacheHttpClientImpl();
            return client.execute(request);
        }

        private void errorResponse(Response response, int httpCode, String message) {
            response.setCode(httpCode);
            response.set(CONTENT_TYPE, "text/plain;charset=utf-8");
            try {
                PrintStream body = response.getPrintStream();
                body.print(message);
                body.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception when building response.", e);
            }
        }
    }
}

