/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockHttpServer.class);
    private ExpectationHandler handler;
    private final HttpResponseProvider responseProvider;
    private final int port;
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    private Connection connection;
    private int noMatchFoundResponseCode = 500;

    public MockHttpServer(int port, HttpResponseProvider responseProvider) {
        Validate.notNull((Object)responseProvider);
        this.port = port;
        this.responseProvider = responseProvider;
    }

    public void start() throws Exception {
        this.handler = new ExpectationHandler();
        this.connection = new SocketConnection((Container)this.handler);
        InetSocketAddress address = new InetSocketAddress(this.port);
        this.connection.connect((SocketAddress)address);
    }

    public void stop() throws Exception {
        this.connection.close();
    }

    public void verify() throws UnsatisfiedExpectationException {
        this.handler.verify();
    }

    public void setNoMatchFoundResponseCode(int code) {
        this.noMatchFoundResponseCode = code;
    }

    public class ExpectationHandler
    implements Container {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Request req, Response response) {
            OutputStream body;
            byte[] data;
            block16: {
                data = null;
                try {
                    if (req.getContentLength() <= 0) break block16;
                    InputStream inputStream = req.getInputStream();
                    try {
                        data = IOUtils.toByteArray((InputStream)inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("IOException when getting request content.", (Throwable)e);
                }
            }
            HttpRequestImpl expectedRequest = new HttpRequestImpl();
            expectedRequest.method(Method.valueOf(req.getMethod()));
            expectedRequest.path(req.getPath().getPath());
            expectedRequest.content(data);
            for (String headerField : req.getNames()) {
                for (String headerFieldValue : req.getValues(headerField)) {
                    expectedRequest.httpMessageHeader(headerField, headerFieldValue);
                }
            }
            for (Map.Entry entry : req.getQuery().entrySet()) {
                expectedRequest.queryParameter((String)entry.getKey(), (String)entry.getValue());
            }
            HttpResponse expectedResponse = MockHttpServer.this.responseProvider.getResponse(expectedRequest);
            if (expectedResponse != null) {
                response.setCode(expectedResponse.getHttpCode());
                if (!StringUtils.isEmpty((CharSequence)expectedResponse.getContentType())) {
                    response.set("Content-Type", expectedResponse.getContentType());
                }
                body = null;
                try {
                    body = response.getOutputStream();
                    if (expectedResponse.getContent() != null) {
                        body.write(expectedResponse.getContent());
                    }
                    body.close();
                }
                catch (IOException e) {
                    LOGGER.error("IOException when getting response content.", (Throwable)e);
                }
            } else {
                response.setCode(MockHttpServer.this.noMatchFoundResponseCode);
                response.set("Content-Type", "text/plain;charset=utf-8");
                try {
                    body = response.getPrintStream();
                    ((PrintStream)body).print("Received unexpected request " + req.getMethod() + ":" + req.getTarget() + " with data: " + data);
                    ((PrintStream)body).close();
                }
                catch (IOException e) {
                    LOGGER.error("IOException when writing response content.", (Throwable)e);
                }
            }
        }

        public void verify() throws UnsatisfiedExpectationException {
            MockHttpServer.this.responseProvider.verify();
        }
    }
}

