/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultHttpResponseProvider
implements HttpResponseProvider {
    private final boolean ignoreAdditionalHeaders;
    private final Map<HttpRequest, HttpResponse> expectedRequests = new HashMap<HttpRequest, HttpResponse>();
    private final Set<HttpRequest> receivedRequests = new HashSet<HttpRequest>();

    public DefaultHttpResponseProvider(boolean ignoreAdditionalHeaders) {
        this.ignoreAdditionalHeaders = ignoreAdditionalHeaders;
    }

    public void set(HttpRequest request, HttpResponse response) {
        this.expectedRequests.put(request, response);
    }

    @Override
    public HttpResponse getResponse(HttpRequest request) {
        HttpResponse httpResponse = this.expectedRequests.get(request);
        if (this.ignoreAdditionalHeaders && httpResponse == null) {
            HttpResponse response = this.findAndIgnoreAdditionalHeaders(request);
            if (response == null) {
                this.receivedRequests.add(request);
            }
            return response;
        }
        this.receivedRequests.add(request);
        return httpResponse;
    }

    @Override
    public void verify() throws UnsatisfiedExpectationException {
        if (!((Object)this.expectedRequests.keySet()).equals(this.receivedRequests)) {
            HashSet<HttpRequest> missing = new HashSet<HttpRequest>();
            for (HttpRequest expectedRequest : this.expectedRequests.keySet()) {
                if (this.receivedRequests.contains(expectedRequest)) continue;
                missing.add(expectedRequest);
            }
            HashSet<HttpRequest> unexpected = new HashSet<HttpRequest>();
            for (HttpRequest receivedRequest : this.receivedRequests) {
                if (this.expectedRequests.keySet().contains(receivedRequest)) continue;
                unexpected.add(receivedRequest);
            }
            throw new UnsatisfiedExpectationException(missing, unexpected);
        }
    }

    private HttpResponse findAndIgnoreAdditionalHeaders(HttpRequest request) {
        for (HttpRequest expectedRequest : this.expectedRequests.keySet()) {
            if (expectedRequest == request) {
                this.receivedRequests.add(expectedRequest);
                return this.expectedRequests.get(expectedRequest);
            }
            if (!Arrays.equals(expectedRequest.getContent(), request.getContent()) || expectedRequest.getMethod() != request.getMethod() || (expectedRequest.getPath() != null ? !expectedRequest.getPath().equals(request.getPath()) : request.getPath() != null)) continue;
            if (!((Object)expectedRequest.getQueryParameters()).equals(request.getQueryParameters()) || !request.getHttpMessageHeaders().containsAll(expectedRequest.getHttpMessageHeaders())) continue;
            this.receivedRequests.add(expectedRequest);
            return this.expectedRequests.get(expectedRequest);
        }
        return null;
    }
}

