/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestFileWriter;
import com.github.kristofa.test.http.QueryParameter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.io.FileUtils;

class HttpRequestFileWriterImpl
implements HttpRequestFileWriter {
    HttpRequestFileWriterImpl() {
    }

    @Override
    public void write(HttpRequest request, File httpRequestFile, File httpRequestEntityFile) {
        try {
            this.writeRequest(request, httpRequestFile);
            this.writeRequestEntity(request, httpRequestEntityFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequest(HttpRequest request, File requestFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(requestFile), "UTF-8"));
        try {
            writer.write("[Method]");
            writer.newLine();
            writer.write(request.getMethod().toString());
            writer.newLine();
            writer.write("[HttpMessageHeader]");
            writer.newLine();
            for (HttpMessageHeader header : request.getHttpMessageHeaders()) {
                writer.write(header.getName() + "=" + header.getValue());
                writer.newLine();
            }
            writer.write("[Path]");
            writer.newLine();
            writer.write(request.getPath());
            writer.newLine();
            writer.write("[QueryParameters]");
            writer.newLine();
            for (QueryParameter parameter : request.getQueryParameters()) {
                writer.write(parameter.getKey() + "=" + parameter.getValue());
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    private void writeRequestEntity(HttpRequest request, File requestEntityFile) throws IOException {
        if (request.getContent() != null) {
            FileUtils.writeByteArrayToFile((File)requestEntityFile, (byte[])request.getContent());
        }
    }
}

