/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.QueryParameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HttpRequestImpl
implements HttpRequest {
    private static final String NOT_SPECIFIED = "null";
    private Method method;
    private byte[] content;
    private String path;
    private final Set<QueryParameter> queryParameters = new TreeSet<QueryParameter>();
    private final Set<HttpMessageHeader> httpMessageHeaders = new TreeSet<HttpMessageHeader>();

    public HttpRequestImpl() {
    }

    public HttpRequestImpl(HttpRequest request) {
        this.content = request.getContent();
        this.method = request.getMethod();
        this.path = request.getPath();
        for (HttpMessageHeader header : request.getHttpMessageHeaders()) {
            this.httpMessageHeaders.add(new HttpMessageHeader(header.getName(), header.getValue()));
        }
        for (QueryParameter parameter : request.getQueryParameters()) {
            this.queryParameters.add(new QueryParameter(parameter.getKey(), parameter.getValue()));
        }
    }

    public HttpRequestImpl method(Method method) {
        this.method = method;
        return this;
    }

    public HttpRequestImpl content(byte[] content) {
        this.content = content;
        return this;
    }

    public HttpRequestImpl path(String path) {
        this.path = path;
        return this;
    }

    public HttpRequestImpl queryParameter(String key, String value) {
        this.queryParameters.add(new QueryParameter(key, value));
        return this;
    }

    public HttpRequestImpl httpMessageHeader(String name, String value) {
        this.httpMessageHeaders.add(new HttpMessageHeader(name, value));
        return this;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public byte[] getContent() {
        if (this.content == null) {
            return null;
        }
        return Arrays.copyOf(this.content, this.content.length);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<QueryParameter> getQueryParameters() {
        return Collections.unmodifiableSet(this.queryParameters);
    }

    @Override
    public Set<HttpMessageHeader> getHttpMessageHeaders() {
        return Collections.unmodifiableSet(this.httpMessageHeaders);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    public String toString() {
        String methodString = this.add("Method: ", (Object)this.getMethod());
        String messageHeaderString = this.add("Message Header: ", this.getHttpMessageHeaders());
        String pathString = this.add("Path: ", this.getPath());
        String queryParamsString = this.add("Query Parameters: ", this.getQueryParameters());
        String contentString = null;
        contentString = this.getContent() == null ? this.add("Content:\n", this.getContent()) : this.add("Content:\n", new String(this.getContent()));
        Object[] array = new String[]{methodString, messageHeaderString, pathString, queryParamsString, contentString};
        return StringUtils.join((Object[])array, (String)"\n");
    }

    private String add(String value, Object object) {
        if (object != null) {
            return value + object;
        }
        return value + NOT_SPECIFIED;
    }
}

