/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.FullHttpRequest;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.RequestConvertor;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockHttpServer.class);
    private ExpectationHandler handler;
    private final HttpResponseProvider responseProvider;
    private final int port;
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    private Connection connection;
    private int noMatchFoundResponseCode = 598;
    private int exceptionResponseCode = 599;

    public MockHttpServer(int port, HttpResponseProvider responseProvider) {
        Validate.notNull((Object)responseProvider);
        this.port = port;
        this.responseProvider = responseProvider;
    }

    public void start() throws IOException {
        this.handler = new ExpectationHandler();
        this.connection = new SocketConnection((Container)this.handler);
        InetSocketAddress address = new InetSocketAddress(this.port);
        this.connection.connect((SocketAddress)address);
    }

    public void stop() throws IOException {
        this.connection.close();
    }

    public void verify() throws UnsatisfiedExpectationException {
        this.handler.verify();
    }

    public void setNoMatchFoundResponseCode(int code) {
        this.noMatchFoundResponseCode = code;
    }

    public void setExceptionResponseCode(int code) {
        this.exceptionResponseCode = code;
    }

    public class ExpectationHandler
    implements Container {
        public void handle(Request req, Response response) {
            try {
                HttpResponse expectedResponse;
                FullHttpRequest receivedFullRequest = RequestConvertor.convert(req);
                HttpRequestImpl receivedRequest = new HttpRequestImpl(receivedFullRequest);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Got request: " + receivedRequest);
                }
                if ((expectedResponse = MockHttpServer.this.responseProvider.getResponse(receivedRequest)) != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Got response for request: " + expectedResponse);
                    }
                    response.setCode(expectedResponse.getHttpCode());
                    if (!StringUtils.isEmpty((CharSequence)expectedResponse.getContentType())) {
                        response.set("Content-Type", expectedResponse.getContentType());
                    }
                    OutputStream body = null;
                    try {
                        body = response.getOutputStream();
                        if (expectedResponse.getContent() != null) {
                            body.write(expectedResponse.getContent());
                        }
                        body.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("IOException when getting response content.", (Throwable)e);
                    }
                } else {
                    LOGGER.error("Did receive an unexpected request:" + receivedRequest);
                    response.setCode(MockHttpServer.this.noMatchFoundResponseCode);
                    response.set("Content-Type", "text/plain;charset=utf-8");
                    try {
                        PrintStream body = response.getPrintStream();
                        body.print("Received unexpected request " + receivedRequest);
                        body.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("IOException when writing response content.", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception.", (Throwable)e);
                response.setCode(MockHttpServer.this.exceptionResponseCode);
                try {
                    response.getPrintStream().close();
                }
                catch (IOException e2) {
                    LOGGER.error("IOException when writing response content.", (Throwable)e2);
                }
            }
        }

        public void verify() throws UnsatisfiedExpectationException {
            MockHttpServer.this.responseProvider.verify();
        }
    }
}

