/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.HttpMessageHeaderField;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseImpl;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.QueryParameter;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class SimpleHttpResponseProvider
implements HttpResponseProvider {
    private LimitedHttpRequestData latestRequest;
    private final Map<LimitedHttpRequestData, HttpResponse> expectedRequests = new HashMap<LimitedHttpRequestData, HttpResponse>();
    private final Set<LimitedHttpRequestData> receivedRequests = new HashSet<LimitedHttpRequestData>();

    public SimpleHttpResponseProvider expect(Method method, String path, String contentType, String requestEntity) {
        this.latestRequest = new LimitedHttpRequestData();
        this.latestRequest.setMethod(method);
        this.latestRequest.setPath(path);
        this.latestRequest.setContent(requestEntity.getBytes());
        this.latestRequest.setContentType(contentType);
        return this;
    }

    public SimpleHttpResponseProvider expect(Method method, String path) {
        this.latestRequest = new LimitedHttpRequestData();
        this.latestRequest.setMethod(method);
        this.latestRequest.setPath(path);
        return this;
    }

    public SimpleHttpResponseProvider respondWith(int httpCode, String contentType, String requestEntity) {
        HttpResponseImpl response = new HttpResponseImpl(httpCode, contentType, requestEntity == null ? null : requestEntity.getBytes());
        this.expectedRequests.put(this.latestRequest, response);
        return this;
    }

    @Override
    public HttpResponse getResponse(HttpRequest request) {
        LimitedHttpRequestData limitedRequest = new LimitedHttpRequestData();
        limitedRequest.setMethod(request.getMethod());
        limitedRequest.setPath(request.getPath());
        limitedRequest.setContent(request.getContent());
        for (QueryParameter qp : request.getQueryParameters()) {
            limitedRequest.addQueryParam(qp.getKey(), qp.getValue());
        }
        for (HttpMessageHeader header : request.getHttpMessageHeaders()) {
            if (!HttpMessageHeaderField.CONTENTTYPE.getValue().equals(header.getName())) continue;
            limitedRequest.setContentType(header.getValue());
            break;
        }
        this.receivedRequests.add(limitedRequest);
        return this.expectedRequests.get(limitedRequest);
    }

    @Override
    public void verify() throws UnsatisfiedExpectationException {
        if (!((Object)this.expectedRequests.keySet()).equals(this.receivedRequests)) {
            HashSet<HttpRequest> missing = new HashSet<HttpRequest>();
            for (LimitedHttpRequestData expectedRequest : this.expectedRequests.keySet()) {
                if (this.receivedRequests.contains(expectedRequest)) continue;
                missing.add(this.httpRequestFor(expectedRequest));
            }
            HashSet<HttpRequest> unexpected = new HashSet<HttpRequest>();
            for (LimitedHttpRequestData receivedRequest : this.receivedRequests) {
                if (this.expectedRequests.keySet().contains(receivedRequest)) continue;
                unexpected.add(this.httpRequestFor(receivedRequest));
            }
            throw new UnsatisfiedExpectationException(missing, unexpected);
        }
    }

    public void reset() {
        this.expectedRequests.clear();
        this.receivedRequests.clear();
        this.latestRequest = new LimitedHttpRequestData();
    }

    private HttpRequest httpRequestFor(LimitedHttpRequestData requestData) {
        HttpRequestImpl httpRequestImpl = new HttpRequestImpl();
        httpRequestImpl.method(requestData.getMethod()).path(requestData.getPath()).content(requestData.getContent());
        if (requestData.getContentType() != null) {
            httpRequestImpl.httpMessageHeader(HttpMessageHeaderField.CONTENTTYPE.getValue(), requestData.getContentType());
        }
        return httpRequestImpl;
    }

    private class LimitedHttpRequestData {
        private Method method;
        private String path;
        private String contentType;
        private byte[] content;
        private final Set<QueryParameter> queryParameters = new TreeSet<QueryParameter>();

        private LimitedHttpRequestData() {
        }

        public Method getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public void setPath(String path) {
            this.path = this.extractQueryParams(path);
        }

        public void addQueryParam(String name, String value) {
            this.queryParameters.add(new QueryParameter(name, value));
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
        }

        private String extractQueryParams(String path) {
            int indexOfQuestionMark = path.indexOf("?");
            if (indexOfQuestionMark >= 0) {
                String newPath = path.substring(0, indexOfQuestionMark);
                String queryParams = path.substring(indexOfQuestionMark + 1);
                List parameters = URLEncodedUtils.parse((String)queryParams, (Charset)Charset.forName("UTF-8"));
                for (NameValuePair parameter : parameters) {
                    this.queryParameters.add(new QueryParameter(parameter.getName(), parameter.getValue()));
                }
                return newPath;
            }
            return path;
        }
    }
}

