/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class UnsatisfiedExpectationException
extends Exception {
    private static final long serialVersionUID = -6003072239642243697L;
    private final List<HttpRequest> missingHttpRequests = new ArrayList<HttpRequest>();
    private final List<HttpRequest> unexpectedHttpRequests = new ArrayList<HttpRequest>();

    public UnsatisfiedExpectationException(Collection<HttpRequest> missingRequests, Collection<HttpRequest> unexpectedRequests) {
        Validate.notNull(missingRequests);
        Validate.notNull(unexpectedRequests);
        Validate.isTrue((!missingRequests.isEmpty() || !unexpectedRequests.isEmpty() ? 1 : 0) != 0);
        this.missingHttpRequests.addAll(missingRequests);
        this.unexpectedHttpRequests.addAll(unexpectedRequests);
    }

    public Collection<HttpRequest> getMissingHttpRequests() {
        return Collections.unmodifiableCollection(this.missingHttpRequests);
    }

    public Collection<HttpRequest> getUnexpectedHttpRequests() {
        return Collections.unmodifiableCollection(this.unexpectedHttpRequests);
    }

    @Override
    public String toString() {
        String missingExpectedRequestsString = "Missing expected requests: " + this.getMissingHttpRequests();
        String unexpectedReceivedRequestsString = "Unexpected received requests: " + this.getUnexpectedHttpRequests();
        return missingExpectedRequestsString + "\n" + unexpectedReceivedRequestsString;
    }
}

