/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.file;

import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import com.github.kristofa.test.http.file.FileNameBuilder;
import com.github.kristofa.test.http.file.HttpRequestFileReader;
import com.github.kristofa.test.http.file.HttpRequestFileReaderImpl;
import com.github.kristofa.test.http.file.HttpResponseFileReader;
import com.github.kristofa.test.http.file.HttpResponseFileReaderImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileHttpResponseProvider
implements HttpResponseProvider {
    private final String directory;
    private final String fileName;
    private final Map<HttpRequest, List<ResponseProxy>> requestResponses = new HashMap<HttpRequest, List<ResponseProxy>>();
    private final HttpRequestFileReader httpRequestFileReader;
    private final HttpResponseFileReader httpResponseFileReader;
    private final List<HttpRequest> unexpectedRequests = new ArrayList<HttpRequest>();
    private boolean initialized = false;

    public FileHttpResponseProvider(String directory, String fileName) {
        this(directory, fileName, new HttpRequestFileReaderImpl(), new HttpResponseFileReaderImpl());
    }

    public FileHttpResponseProvider(String directory, String fileName, HttpRequestFileReader requestFileReader, HttpResponseFileReader responseFileReader) {
        this.directory = directory;
        this.fileName = fileName;
        this.httpRequestFileReader = requestFileReader;
        this.httpResponseFileReader = responseFileReader;
    }

    @Override
    public synchronized HttpResponse getResponse(HttpRequest request) {
        List<ResponseProxy> proxyList;
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        if ((proxyList = this.requestResponses.get(request)) != null) {
            int size = proxyList.size();
            for (int index = 0; index < size; ++index) {
                ResponseProxy responseProxy = proxyList.get(index);
                if (responseProxy.requested) continue;
                File responseFile = new File(this.directory, FileNameBuilder.RESPONSE_FILE_NAME.getFileName(this.fileName, responseProxy.seqNr));
                File responseEntityFile = new File(this.directory, FileNameBuilder.RESPONSE_ENTITY_FILE_NAME.getFileName(this.fileName, responseProxy.seqNr));
                responseProxy.requested = true;
                return this.httpResponseFileReader.read(responseFile, responseEntityFile);
            }
            this.unexpectedRequests.add(request);
        } else {
            this.unexpectedRequests.add(request);
        }
        return null;
    }

    @Override
    public void verify() throws UnsatisfiedExpectationException {
        ArrayList<HttpRequest> missingRequests = new ArrayList<HttpRequest>();
        for (HttpRequest request : this.requestResponses.keySet()) {
            List<ResponseProxy> responseProxies = this.requestResponses.get(request);
            for (ResponseProxy responseProxy : responseProxies) {
                if (responseProxy.requested) continue;
                missingRequests.add(request);
            }
        }
        if (!this.unexpectedRequests.isEmpty() || !missingRequests.isEmpty()) {
            throw new UnsatisfiedExpectationException(missingRequests, this.unexpectedRequests);
        }
    }

    private void init() {
        int seqNr = 1;
        File requestFile = new File(this.directory, FileNameBuilder.REQUEST_FILE_NAME.getFileName(this.fileName, seqNr));
        if (!requestFile.exists()) {
            throw new IllegalStateException("No saved http request/responses found. File " + requestFile + " not found.");
        }
        while (requestFile.exists()) {
            File responseFile = new File(this.directory, FileNameBuilder.RESPONSE_FILE_NAME.getFileName(this.fileName, seqNr));
            if (!responseFile.exists()) {
                throw new IllegalStateException("Found request file (" + requestFile + ") but no matching response file: " + responseFile);
            }
            this.cacheRequest(this.fileName, seqNr);
            requestFile = new File(this.directory, FileNameBuilder.REQUEST_FILE_NAME.getFileName(this.fileName, ++seqNr));
        }
    }

    private void cacheRequest(String fileName, int seqNr) {
        File requestFile = new File(this.directory, FileNameBuilder.REQUEST_FILE_NAME.getFileName(fileName, seqNr));
        File requestEntityFile = new File(this.directory, FileNameBuilder.REQUEST_ENTITY_FILE_NAME.getFileName(fileName, seqNr));
        HttpRequest request = this.httpRequestFileReader.read(requestFile, requestEntityFile);
        ResponseProxy responseProxy = new ResponseProxy();
        responseProxy.seqNr = seqNr;
        responseProxy.requested = false;
        List<ResponseProxy> responseProxies = this.requestResponses.get(request);
        if (responseProxies == null) {
            ArrayList<ResponseProxy> newResponseProxyList = new ArrayList<ResponseProxy>();
            newResponseProxyList.add(responseProxy);
            this.requestResponses.put(request, newResponseProxyList);
        } else {
            responseProxies.add(responseProxy);
        }
    }

    private class ResponseProxy {
        public int seqNr;
        public boolean requested;

        private ResponseProxy() {
        }
    }
}

