/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.file;

import com.github.kristofa.test.http.HttpRequestResponseLogger;
import com.github.kristofa.test.http.HttpRequestResponseLoggerFactory;
import com.github.kristofa.test.http.file.HttpRequestFileWriter;
import com.github.kristofa.test.http.file.HttpRequestFileWriterImpl;
import com.github.kristofa.test.http.file.HttpRequestResponseFileLogger;
import com.github.kristofa.test.http.file.HttpResponseFileWriter;
import com.github.kristofa.test.http.file.HttpResponseFileWriterImpl;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;

public class HttpRequestResponseFileLoggerFactory
implements HttpRequestResponseLoggerFactory {
    private final AtomicInteger atomicInteger = new AtomicInteger();
    private final String directory;
    private final String fileName;
    private final HttpRequestFileWriter requestWriter;
    private final HttpResponseFileWriter responseWriter;

    public HttpRequestResponseFileLoggerFactory(String directory, String fileName) {
        Validate.notBlank((CharSequence)directory);
        Validate.notBlank((CharSequence)fileName);
        this.directory = directory;
        this.fileName = fileName;
        this.requestWriter = new HttpRequestFileWriterImpl();
        this.responseWriter = new HttpResponseFileWriterImpl();
    }

    @Override
    public HttpRequestResponseLogger getHttpRequestResponseLogger() {
        return new HttpRequestResponseFileLogger(this.directory, this.fileName, this.atomicInteger.incrementAndGet(), this.requestWriter, this.responseWriter);
    }
}

