/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.AbstractHttpRequestMatchingFilter;
import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.HttpRequestMatchingContext;
import com.github.kristofa.test.http.HttpRequestMatchingContextImpl;
import java.util.HashSet;
import java.util.Set;

public class AllExceptContentTypeHeaderFilter
extends AbstractHttpRequestMatchingFilter {
    private static final String CONTENTTYPE_HEADER_NAME = "Content-Type";

    @Override
    public HttpRequestMatchingContext filter(HttpRequestMatchingContext context) {
        HttpRequest originalRequest = context.originalRequest();
        HttpRequest newOriginal = this.filter(originalRequest);
        HttpRequest otherRequest = context.otherRequest();
        HttpRequest newOther = this.filter(otherRequest);
        if (originalRequest != newOriginal || otherRequest != newOther) {
            return new HttpRequestMatchingContextImpl(newOriginal, newOther, context.response());
        }
        return context;
    }

    private HttpRequest filter(HttpRequest request) {
        Set<HttpMessageHeader> httpMessageHeaders = request.getHttpMessageHeaders();
        if (httpMessageHeaders.isEmpty()) {
            return request;
        }
        if (httpMessageHeaders.size() == 1 && request.getHttpMessageHeaders(CONTENTTYPE_HEADER_NAME).size() == 1) {
            return request;
        }
        HttpRequestImpl copy = new HttpRequestImpl(request);
        HashSet<HttpMessageHeader> headersToRemove = new HashSet<HttpMessageHeader>();
        for (HttpMessageHeader header : copy.getHttpMessageHeaders()) {
            if (header.getName().equals(CONTENTTYPE_HEADER_NAME)) continue;
            headersToRemove.add(header);
        }
        for (HttpMessageHeader headerToRemove : headersToRemove) {
            copy.removeHttpMessageHeader(headerToRemove.getName(), headerToRemove.getValue());
        }
        return copy;
    }
}

