/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.ForwardHttpRequestBuilder;
import com.github.kristofa.test.http.FullHttpRequest;
import com.github.kristofa.test.http.HttpRequestResponseLogger;
import com.github.kristofa.test.http.HttpRequestResponseLoggerFactory;
import com.github.kristofa.test.http.HttpResponseImpl;
import com.github.kristofa.test.http.RequestConvertor;
import com.github.kristofa.test.http.client.ApacheHttpClientImpl;
import com.github.kristofa.test.http.client.HttpClientResponse;
import com.github.kristofa.test.http.client.HttpRequestException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHttpProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingHttpProxy.class);
    private final int port;
    private final Collection<ForwardHttpRequestBuilder> requestBuilders = new HashSet<ForwardHttpRequestBuilder>();
    private final HttpRequestResponseLoggerFactory loggerFactory;
    private Connection connection;
    private ProxyImplementation proxy;

    public LoggingHttpProxy(int port, Collection<ForwardHttpRequestBuilder> requestBuilders, HttpRequestResponseLoggerFactory loggerFactory) {
        Validate.isTrue((requestBuilders != null && !requestBuilders.isEmpty() ? 1 : 0) != 0, (String)"At least 1 ForwardHttpRequestBuilder should be provided.", (Object[])new Object[0]);
        Validate.notNull((Object)loggerFactory, (String)"HttpRequestResponseLoggerFactory should not be null.", (Object[])new Object[0]);
        this.port = port;
        this.requestBuilders.addAll(requestBuilders);
        this.loggerFactory = loggerFactory;
    }

    public void start() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.proxy = new ProxyImplementation();
        this.connection = new SocketConnection((Container)this.proxy);
        InetSocketAddress address = new InetSocketAddress(this.port);
        this.connection.connect((SocketAddress)address);
        LOGGER.debug("Started on port: " + this.port);
    }

    public void stop() throws IOException {
        LOGGER.debug("Stopping and closing connection.");
        this.connection.close();
    }

    private class ProxyImplementation
    implements Container {
        private static final int UNKNOWN_EXCEPTION_HTTP_CODE = 573;
        private static final int FORWARD_REQUEST_FAILED_HTTP_CODE = 571;
        private static final int COPY_RESPONSE_FAILED_ERROR_HTTP_CODE = 572;
        private static final int NO_FORWARD_REQUEST_ERROR_HTTP_CODE = 570;
        private static final String CONTENT_TYPE = "Content-Type";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Request request, Response response) {
            block18: {
                try {
                    ForwardHttpRequestBuilder forwardRequestBuilder;
                    FullHttpRequest httpRequest = RequestConvertor.convert(request);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Received request: " + httpRequest);
                    }
                    FullHttpRequest forwardHttpRequest = null;
                    Iterator i$ = LoggingHttpProxy.this.requestBuilders.iterator();
                    while (i$.hasNext() && (forwardHttpRequest = (forwardRequestBuilder = (ForwardHttpRequestBuilder)i$.next()).getForwardRequest(httpRequest)) == null) {
                    }
                    if (forwardHttpRequest == null) {
                        LOGGER.error("Got unexpected request: " + httpRequest);
                        this.errorResponse(response, 570, "Received unexpected request:\n" + httpRequest.toString());
                        break block18;
                    }
                    LOGGER.debug("Logging request.");
                    HttpRequestResponseLogger logger = LoggingHttpProxy.this.loggerFactory.getHttpRequestResponseLogger();
                    logger.log(httpRequest);
                    try {
                        LOGGER.debug("Forward request.");
                        HttpClientResponse<InputStream> forwardResponse = this.forward(forwardHttpRequest);
                        LOGGER.debug("Got response for forward request.");
                        try {
                            byte[] responseEntity;
                            InputStream inputStream = forwardResponse.getResponseEntity();
                            try {
                                responseEntity = IOUtils.toByteArray((InputStream)inputStream);
                            }
                            finally {
                                inputStream.close();
                            }
                            HttpResponseImpl httpResponse = new HttpResponseImpl(forwardResponse.getHttpCode(), forwardResponse.getContentType(), responseEntity);
                            LOGGER.debug("Logging response");
                            logger.log(httpResponse);
                            response.setCode(forwardResponse.getHttpCode());
                            response.set(CONTENT_TYPE, forwardResponse.getContentType());
                            OutputStream outputStream = response.getOutputStream();
                            try {
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(responseEntity);
                                IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
                                byteArrayInputStream.close();
                            }
                            finally {
                                outputStream.close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("IOException when trying to copy response of forward request.", (Throwable)e);
                            this.errorResponse(response, 572, "Exception when copying streams." + e.getMessage());
                        }
                        finally {
                            forwardResponse.close();
                        }
                    }
                    catch (HttpRequestException e) {
                        LOGGER.error("HttpRequestException when forwarding request.", (Throwable)e);
                        this.errorResponse(response, 571, "Exception when forwarding request." + e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception.", (Throwable)e);
                    this.errorResponse(response, 573, "Exception: " + e.getMessage());
                }
            }
        }

        private HttpClientResponse<InputStream> forward(FullHttpRequest request) throws HttpRequestException {
            ApacheHttpClientImpl client = new ApacheHttpClientImpl();
            return client.execute(request);
        }

        private void errorResponse(Response response, int httpCode, String message) {
            response.setCode(httpCode);
            response.set(CONTENT_TYPE, "text/plain;charset=utf-8");
            try {
                PrintStream body = response.getPrintStream();
                body.print(message);
                body.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception when building response.", e);
            }
        }
    }
}

