/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.FullHttpRequest;
import com.github.kristofa.test.http.FullHttpRequestImpl;
import com.github.kristofa.test.http.Method;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.simpleframework.http.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestConvertor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestConvertor.class);

    RequestConvertor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FullHttpRequest convert(Request request) {
        byte[] data = null;
        try {
            InputStream inputStream = request.getInputStream();
            try {
                data = IOUtils.toByteArray((InputStream)inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException when getting request content.", (Throwable)e);
        }
        FullHttpRequestImpl httpRequest = new FullHttpRequestImpl();
        httpRequest.domain(request.getAddress().getDomain());
        httpRequest.port(request.getAddress().getPort());
        httpRequest.method(Method.valueOf(request.getMethod()));
        httpRequest.path(request.getPath().getPath());
        if (data.length > 0) {
            httpRequest.content(data);
        }
        for (String headerField : request.getNames()) {
            for (String headerFieldValue : request.getValues(headerField)) {
                httpRequest.httpMessageHeader(headerField, headerFieldValue);
            }
        }
        for (Map.Entry entry : request.getQuery().entrySet()) {
            httpRequest.queryParameter((String)entry.getKey(), (String)entry.getValue());
        }
        return httpRequest;
    }
}

