/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.client;

import com.github.kristofa.test.http.FullHttpRequest;
import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.client.ApacheHttpClientResponseImpl;
import com.github.kristofa.test.http.client.CustomHttpClient;
import com.github.kristofa.test.http.client.GetException;
import com.github.kristofa.test.http.client.HttpClient;
import com.github.kristofa.test.http.client.HttpClientResponse;
import com.github.kristofa.test.http.client.HttpRequestException;
import com.github.kristofa.test.http.client.PostException;
import com.github.kristofa.test.http.client.PutException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

public class ApacheHttpClientImpl
implements HttpClient {
    @Override
    public HttpClientResponse<InputStream> execute(FullHttpRequest request) throws HttpRequestException {
        if (request.getMethod().equals((Object)Method.GET)) {
            HttpGet httpGet = new HttpGet(request.getUrl());
            this.populateHeader(request, (HttpRequestBase)httpGet);
            try {
                return this.execute((HttpRequestBase)httpGet);
            }
            catch (IOException e1) {
                throw new GetException(e1);
            }
        }
        if (request.getMethod().equals((Object)Method.PUT)) {
            HttpPut httpPut = new HttpPut(request.getUrl());
            this.populateHeader(request, (HttpRequestBase)httpPut);
            try {
                return this.execute((HttpEntityEnclosingRequestBase)httpPut, request.getContent());
            }
            catch (IOException e1) {
                throw new PutException(e1);
            }
        }
        if (request.getMethod().equals((Object)Method.POST)) {
            HttpPost httpPost = new HttpPost(request.getUrl());
            this.populateHeader(request, (HttpRequestBase)httpPost);
            try {
                return this.execute((HttpEntityEnclosingRequestBase)httpPost, request.getContent());
            }
            catch (IOException e1) {
                throw new PostException(e1);
            }
        }
        if (request.getMethod().equals((Object)Method.DELETE)) {
            HttpDelete httpDelete = new HttpDelete(request.getUrl());
            this.populateHeader(request, (HttpRequestBase)httpDelete);
            try {
                return this.execute((HttpRequestBase)httpDelete);
            }
            catch (IOException e1) {
                throw new GetException(e1);
            }
        }
        throw new HttpRequestException("Unsupported operation: " + (Object)((Object)request.getMethod()));
    }

    org.apache.http.client.HttpClient getClient() {
        return new CustomHttpClient();
    }

    private void populateHeader(FullHttpRequest request, HttpRequestBase apacheRequest) {
        for (HttpMessageHeader header : request.getHttpMessageHeaders()) {
            apacheRequest.addHeader(header.getName(), header.getValue());
        }
    }

    private HttpClientResponse<InputStream> execute(HttpEntityEnclosingRequestBase request, byte[] content) throws IOException {
        if (content != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(content));
        }
        return this.execute((HttpRequestBase)request);
    }

    private HttpClientResponse<InputStream> execute(HttpRequestBase request) throws IOException {
        org.apache.http.client.HttpClient client = this.getClient();
        try {
            HttpResponse httpResponse = client.execute((HttpUriRequest)request);
            return this.buildResponse(client, httpResponse);
        }
        catch (IOException e) {
            client.getConnectionManager().shutdown();
            throw e;
        }
    }

    private HttpClientResponse<InputStream> buildResponse(org.apache.http.client.HttpClient client, HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        ApacheHttpClientResponseImpl<InputStream> httpResponse = new ApacheHttpClientResponseImpl<InputStream>(status, client);
        httpResponse.setResponseEntity(response.getEntity().getContent());
        if (response.getEntity().getContentType() != null) {
            httpResponse.setContentType(response.getEntity().getContentType().getValue());
        }
        if (status < 200 || status > 299) {
            httpResponse.setErrorMessage("Got HTTP return code " + status);
        }
        return httpResponse;
    }
}

