/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.client;

import com.github.kristofa.test.http.client.HttpClientResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.client.HttpClient;

class ApacheHttpClientResponseImpl<T>
implements HttpClientResponse<T> {
    private final int httpCode;
    private final HttpClient httpClient;
    private String errorMessage;
    private T responseEntity;
    private String contentType;

    public ApacheHttpClientResponseImpl(int httpCode, HttpClient httpClient) {
        Validate.notNull((Object)httpClient);
        this.httpCode = httpCode;
        this.httpClient = httpClient;
    }

    @Override
    public boolean success() {
        return StringUtils.isBlank((CharSequence)this.errorMessage);
    }

    @Override
    public int getHttpCode() {
        return this.httpCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public T getResponseEntity() {
        return this.responseEntity;
    }

    public void setResponseEntity(T responseEntity) {
        this.responseEntity = responseEntity;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void close() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }
}

