/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.file;

import com.github.kristofa.test.http.AbstractHttpResponseProvider;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.file.FileHttpResponseProxy;
import com.github.kristofa.test.http.file.FileNameBuilder;
import com.github.kristofa.test.http.file.HttpRequestFileReader;
import com.github.kristofa.test.http.file.HttpRequestFileReaderImpl;
import com.github.kristofa.test.http.file.HttpResponseFileReader;
import com.github.kristofa.test.http.file.HttpResponseFileReaderImpl;
import java.io.File;

public class FileHttpResponseProvider
extends AbstractHttpResponseProvider {
    private final String directory;
    private final String fileName;
    private final HttpRequestFileReader httpRequestFileReader;
    private final HttpResponseFileReader httpResponseFileReader;

    public FileHttpResponseProvider(String directory, String fileName) {
        this(directory, fileName, new HttpRequestFileReaderImpl(), new HttpResponseFileReaderImpl());
    }

    public FileHttpResponseProvider(String directory, String fileName, HttpRequestFileReader requestFileReader, HttpResponseFileReader responseFileReader) {
        this.directory = directory;
        this.fileName = fileName;
        this.httpRequestFileReader = requestFileReader;
        this.httpResponseFileReader = responseFileReader;
    }

    @Override
    protected void lazyInitializeExpectedRequestsAndResponses() {
        int seqNr = 1;
        File requestFile = new File(this.directory, FileNameBuilder.REQUEST_FILE_NAME.getFileName(this.fileName, seqNr));
        if (!requestFile.exists()) {
            throw new IllegalStateException("No saved http request/responses found. File " + requestFile + " not found.");
        }
        while (requestFile.exists()) {
            File responseFile = new File(this.directory, FileNameBuilder.RESPONSE_FILE_NAME.getFileName(this.fileName, seqNr));
            if (!responseFile.exists()) {
                throw new IllegalStateException("Found request file (" + requestFile + ") but no matching response file: " + responseFile);
            }
            this.submitRequest(this.fileName, seqNr);
            requestFile = new File(this.directory, FileNameBuilder.REQUEST_FILE_NAME.getFileName(this.fileName, ++seqNr));
        }
    }

    private void submitRequest(String fileName, int seqNr) {
        File requestFile = new File(this.directory, FileNameBuilder.REQUEST_FILE_NAME.getFileName(fileName, seqNr));
        File requestEntityFile = new File(this.directory, FileNameBuilder.REQUEST_ENTITY_FILE_NAME.getFileName(fileName, seqNr));
        HttpRequest request = this.httpRequestFileReader.read(requestFile, requestEntityFile);
        FileHttpResponseProxy responseProxy = new FileHttpResponseProxy(this.directory, fileName, seqNr, this.httpResponseFileReader);
        this.addExpected(request, responseProxy);
    }
}

