/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.file;

import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestResponseLogger;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.file.FileNameBuilder;
import com.github.kristofa.test.http.file.HttpRequestFileWriter;
import com.github.kristofa.test.http.file.HttpResponseFileWriter;
import java.io.File;
import org.apache.commons.lang3.Validate;

class HttpRequestResponseFileLogger
implements HttpRequestResponseLogger {
    private final String directory;
    private final String fileName;
    private final int seqNr;
    private final HttpRequestFileWriter requestWriter;
    private final HttpResponseFileWriter responseWriter;

    public HttpRequestResponseFileLogger(String directory, String fileName, int seqNr, HttpRequestFileWriter requestWriter, HttpResponseFileWriter responseWriter) {
        Validate.notNull((Object)directory);
        Validate.notBlank((CharSequence)fileName);
        Validate.notNull((Object)requestWriter);
        Validate.notNull((Object)responseWriter);
        this.directory = directory;
        this.fileName = fileName;
        this.seqNr = seqNr;
        this.requestWriter = requestWriter;
        this.responseWriter = responseWriter;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSeqNr() {
        return this.seqNr;
    }

    public HttpRequestFileWriter getRequestFileWriter() {
        return this.requestWriter;
    }

    public HttpResponseFileWriter getResponseFileWriter() {
        return this.responseWriter;
    }

    @Override
    public void log(HttpRequest request) {
        String requestFileName = FileNameBuilder.REQUEST_FILE_NAME.getFileName(this.fileName, this.seqNr);
        String requestEntityFileName = FileNameBuilder.REQUEST_ENTITY_FILE_NAME.getFileName(this.fileName, this.seqNr);
        this.requestWriter.write(request, new File(this.directory, requestFileName), new File(this.directory, requestEntityFileName));
    }

    @Override
    public void log(HttpResponse response) {
        String responseFileName = FileNameBuilder.RESPONSE_FILE_NAME.getFileName(this.fileName, this.seqNr);
        String responseEntityFileName = FileNameBuilder.RESPONSE_ENTITY_FILE_NAME.getFileName(this.fileName, this.seqNr);
        this.responseWriter.write(response, new File(this.directory, responseFileName), new File(this.directory, responseEntityFileName));
    }
}

