/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.file;

import com.github.kristofa.test.http.HttpRequestResponseLogger;
import com.github.kristofa.test.http.HttpRequestResponseLoggerFactory;
import com.github.kristofa.test.http.file.FileNameBuilder;
import com.github.kristofa.test.http.file.HttpRequestFileWriter;
import com.github.kristofa.test.http.file.HttpRequestFileWriterImpl;
import com.github.kristofa.test.http.file.HttpRequestResponseFileLogger;
import com.github.kristofa.test.http.file.HttpResponseFileWriter;
import com.github.kristofa.test.http.file.HttpResponseFileWriterImpl;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestResponseFileLoggerFactory
implements HttpRequestResponseLoggerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestResponseFileLoggerFactory.class);
    private final AtomicInteger atomicInteger = new AtomicInteger();
    private final String directory;
    private final String fileName;
    private final HttpRequestFileWriter requestWriter;
    private final HttpResponseFileWriter responseWriter;
    private final boolean deleteExistingFiles;
    private boolean firstRequest = true;

    public HttpRequestResponseFileLoggerFactory(String directory, String fileName) {
        this(directory, fileName, false);
    }

    public HttpRequestResponseFileLoggerFactory(String directory, String fileName, boolean deleteExistingFiles) {
        Validate.notBlank((CharSequence)directory);
        Validate.notBlank((CharSequence)fileName);
        this.directory = directory;
        this.fileName = fileName;
        this.deleteExistingFiles = deleteExistingFiles;
        this.requestWriter = new HttpRequestFileWriterImpl();
        this.responseWriter = new HttpResponseFileWriterImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRequestResponseLogger getHttpRequestResponseLogger() {
        if (this.firstRequest && this.deleteExistingFiles) {
            AtomicInteger atomicInteger = this.atomicInteger;
            synchronized (atomicInteger) {
                if (this.firstRequest) {
                    this.deleteExistingFiles();
                    this.firstRequest = false;
                }
            }
        }
        return new HttpRequestResponseFileLogger(this.directory, this.fileName, this.atomicInteger.incrementAndGet(), this.requestWriter, this.responseWriter);
    }

    private void deleteExistingFiles() {
        int seqNr = 1;
        String requestFileName;
        while (!FileDeleteStatus.DID_NOT_EXIST.equals((Object)this.delete(this.directory, requestFileName = FileNameBuilder.REQUEST_FILE_NAME.getFileName(this.fileName, seqNr)))) {
            String requestEntityFileName = FileNameBuilder.REQUEST_ENTITY_FILE_NAME.getFileName(this.fileName, seqNr);
            this.delete(this.directory, requestEntityFileName);
            String responseFileName = FileNameBuilder.RESPONSE_FILE_NAME.getFileName(this.fileName, seqNr);
            this.delete(this.directory, responseFileName);
            String responseEntityFileName = FileNameBuilder.RESPONSE_ENTITY_FILE_NAME.getFileName(this.fileName, seqNr);
            this.delete(this.directory, responseEntityFileName);
            ++seqNr;
        }
        return;
    }

    private FileDeleteStatus delete(String directory, String fileName) {
        File file = new File(directory, fileName);
        if (file.exists()) {
            if (!file.delete()) {
                LOGGER.warn("Unable to delete " + file);
                return FileDeleteStatus.DELETE_FAILED;
            }
            return FileDeleteStatus.DELETE_SUCCES;
        }
        return FileDeleteStatus.DID_NOT_EXIST;
    }

    private static enum FileDeleteStatus {
        DID_NOT_EXIST,
        DELETE_SUCCES,
        DELETE_FAILED;

    }
}

