/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.file;

import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.file.HttpResponseFileWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

class HttpResponseFileWriterImpl
implements HttpResponseFileWriter {
    HttpResponseFileWriterImpl() {
    }

    @Override
    public void write(HttpResponse response, File httpResponseFile, File httpResponseEntityFile) {
        try {
            this.writeResponse(response, httpResponseFile);
            this.writeResponseEntity(response, httpResponseEntityFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(HttpResponse httpResponse, File httpResponseFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(httpResponseFile), "UTF-8"));
        try {
            writer.write("[HttpCode]");
            writer.newLine();
            writer.write(String.valueOf(httpResponse.getHttpCode()));
            writer.newLine();
            writer.write("[ContentType]");
            writer.newLine();
            if (!StringUtils.isBlank((CharSequence)httpResponse.getContentType())) {
                writer.write(httpResponse.getContentType());
            }
            writer.newLine();
        }
        finally {
            writer.close();
        }
    }

    private void writeResponseEntity(HttpResponse httpResponse, File httpResponseEntityFile) throws IOException {
        if (httpResponse.getContent() != null) {
            FileUtils.writeByteArrayToFile((File)httpResponseEntityFile, (byte[])httpResponse.getContent());
        }
    }
}

