/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestMatchingContext;
import com.github.kristofa.test.http.HttpRequestMatchingContextImpl;
import com.github.kristofa.test.http.HttpRequestMatchingFilter;
import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.HttpResponseProxy;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpResponseProvider
implements HttpResponseProvider {
    private final Map<HttpRequest, List<HttpResponseProxy>> requestMap = new HashMap<HttpRequest, List<HttpResponseProxy>>();
    private final List<HttpRequest> unexpectedRequests = new ArrayList<HttpRequest>();
    private HttpRequestMatchingFilter requestMatcherFilter;
    private boolean initialized = false;

    protected final void addExpected(HttpRequest request, HttpResponseProxy responseProxy) {
        List<HttpResponseProxy> list = this.requestMap.get(request);
        if (list == null) {
            list = new ArrayList<HttpResponseProxy>();
            this.requestMap.put(request, list);
        }
        list.add(responseProxy);
    }

    protected void lazyInitializeExpectedRequestsAndResponses() {
    }

    protected final void resetState() {
        this.requestMap.clear();
        this.unexpectedRequests.clear();
    }

    @Override
    public final synchronized HttpResponse getResponse(HttpRequest request) {
        HttpResponseProxy responseProxyForExactMatchingRequest;
        if (!this.initialized) {
            this.lazyInitializeExpectedRequestsAndResponses();
            this.initialized = true;
        }
        if ((responseProxyForExactMatchingRequest = this.getFirstNotYetConsumedResponseProxyFor(request)) != null) {
            return responseProxyForExactMatchingRequest.consume();
        }
        if (this.requestMatcherFilter != null) {
            for (HttpRequest originalRequest : this.requestMap.keySet()) {
                HttpResponseProxy originalResponseProxy = this.getFirstNotYetConsumedResponseProxyFor(originalRequest);
                if (originalResponseProxy == null) continue;
                HttpRequestMatchingContext context = new HttpRequestMatchingContextImpl(originalRequest, request, originalResponseProxy.getResponse());
                for (HttpRequestMatchingFilter next = this.requestMatcherFilter; next != null; next = next.next()) {
                    if (!(context = next.filter(context)).originalRequest().equals(context.otherRequest())) continue;
                    originalResponseProxy.consume();
                    return context.response();
                }
            }
        }
        this.unexpectedRequests.add(request);
        return null;
    }

    public final void addHttpRequestMatchingFilter(HttpRequestMatchingFilter filter) {
        if (this.requestMatcherFilter == null) {
            this.requestMatcherFilter = filter;
        } else {
            HttpRequestMatchingFilter matchingFilter = this.requestMatcherFilter;
            while (matchingFilter.next() != null) {
                matchingFilter = matchingFilter.next();
            }
            matchingFilter.setNext(filter);
        }
    }

    @Override
    public final void verify() throws UnsatisfiedExpectationException {
        ArrayList<HttpRequest> missingRequests = new ArrayList<HttpRequest>();
        for (Map.Entry<HttpRequest, List<HttpResponseProxy>> entry : this.requestMap.entrySet()) {
            for (HttpResponseProxy responseProxy : entry.getValue()) {
                if (responseProxy.consumed()) continue;
                missingRequests.add(entry.getKey());
            }
        }
        if (!this.unexpectedRequests.isEmpty() || !missingRequests.isEmpty()) {
            throw new UnsatisfiedExpectationException(missingRequests, this.unexpectedRequests);
        }
    }

    private HttpResponseProxy getFirstNotYetConsumedResponseProxyFor(HttpRequest request) {
        List<HttpResponseProxy> list = this.requestMap.get(request);
        if (list != null) {
            for (HttpResponseProxy proxy : list) {
                if (proxy.consumed()) continue;
                return proxy;
            }
        }
        return null;
    }
}

