/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.AbstractHttpRequestMatchingFilter;
import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.HttpRequestMatchingContext;
import com.github.kristofa.test.http.HttpRequestMatchingContextImpl;
import java.util.HashSet;

public class AllExceptOriginalHeadersFilter
extends AbstractHttpRequestMatchingFilter {
    @Override
    public HttpRequestMatchingContext filter(HttpRequestMatchingContext context) {
        HttpRequest originalRequest = context.originalRequest();
        HttpRequest otherRequest = context.otherRequest();
        HashSet<String> headersToRemove = new HashSet<String>();
        for (HttpMessageHeader header : otherRequest.getHttpMessageHeaders()) {
            if (!originalRequest.getHttpMessageHeaders(header.getName()).isEmpty()) continue;
            headersToRemove.add(header.getName());
        }
        if (!headersToRemove.isEmpty()) {
            HttpRequestImpl otherRequestCopy = new HttpRequestImpl(otherRequest);
            for (String header : headersToRemove) {
                otherRequestCopy.removeHttpMessageHeaders(header);
            }
            return new HttpRequestMatchingContextImpl(originalRequest, otherRequestCopy, context.response());
        }
        return context;
    }
}

