/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.FullHttpRequest;
import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.QueryParameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class FullHttpRequestImpl
implements FullHttpRequest {
    private static final String PORT_SEPARATOR = ":";
    private static final String NOT_SPECIFIED = "null";
    private final HttpRequestImpl httpRequest;
    private String domain;
    private Integer port;

    public FullHttpRequestImpl() {
        this.httpRequest = new HttpRequestImpl();
    }

    public FullHttpRequestImpl(FullHttpRequest request) {
        this.httpRequest = new HttpRequestImpl(request);
        this.domain = request.getDomain();
        this.port = request.getPort();
    }

    public FullHttpRequestImpl method(Method method) {
        this.httpRequest.method(method);
        return this;
    }

    public FullHttpRequestImpl httpMessageHeader(String name, String value) {
        this.httpRequest.httpMessageHeader(name, value);
        return this;
    }

    public FullHttpRequestImpl content(byte[] content) {
        this.httpRequest.content(content);
        return this;
    }

    public FullHttpRequestImpl domain(String domain) {
        this.domain = domain;
        return this;
    }

    public FullHttpRequestImpl port(Integer port) {
        this.port = port;
        return this;
    }

    public FullHttpRequestImpl path(String path) {
        this.httpRequest.path(path);
        return this;
    }

    public FullHttpRequestImpl queryParameter(String key, String value) {
        this.httpRequest.queryParameter(key, value);
        return this;
    }

    @Override
    public Method getMethod() {
        return this.httpRequest.getMethod();
    }

    @Override
    public byte[] getContent() {
        return this.httpRequest.getContent();
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public String getPath() {
        return this.httpRequest.getPath();
    }

    @Override
    public Set<QueryParameter> getQueryParameters() {
        return this.httpRequest.getQueryParameters();
    }

    @Override
    public Set<HttpMessageHeader> getHttpMessageHeaders() {
        return this.httpRequest.getHttpMessageHeaders();
    }

    @Override
    public Set<QueryParameter> getQueryParameters(String key) {
        return this.httpRequest.getQueryParameters(key);
    }

    @Override
    public Set<HttpMessageHeader> getHttpMessageHeaders(String name) {
        return this.httpRequest.getHttpMessageHeaders(name);
    }

    @Override
    public String getUrl() {
        try {
            String host;
            String queryParamsAsString = this.getQueryParamsAsString();
            String string = host = this.domain == null ? "" : this.domain;
            if (this.port != null) {
                host = host + PORT_SEPARATOR + this.port;
            }
            URI uri = new URI("http", host, this.httpRequest.getPath(), queryParamsAsString.isEmpty() ? null : queryParamsAsString, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        String httpRequestString = this.httpRequest.toString();
        String domainString = this.add("Domain: ", this.domain);
        String portString = this.add("Port: ", this.port);
        Object[] array = new String[]{httpRequestString, domainString, portString};
        return StringUtils.join((Object[])array, (String)"\n");
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    private String add(String value, Object object) {
        if (object != null) {
            return value + object;
        }
        return value + NOT_SPECIFIED;
    }

    private String getQueryParamsAsString() {
        String queryParamsAsString = "";
        boolean first = true;
        for (QueryParameter parameter : this.httpRequest.getQueryParameters()) {
            if (first) {
                first = false;
            } else {
                queryParamsAsString = queryParamsAsString + "&";
            }
            queryParamsAsString = queryParamsAsString + parameter.toString();
        }
        return queryParamsAsString;
    }
}

