/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HttpMessageHeader
implements Comparable<HttpMessageHeader> {
    private final String name;
    private final String value;

    public HttpMessageHeader(String name, String value) {
        Validate.notBlank((CharSequence)name, (String)"HttpHeader name is blank.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)value, (String)("HttpHeader value for name " + name + " is blank"), (Object[])new Object[0]);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }

    @Override
    public int compareTo(HttpMessageHeader o) {
        int compareTo = this.getName().compareTo(o.getName());
        if (compareTo != 0) {
            return compareTo;
        }
        return this.getValue().compareTo(o.getValue());
    }
}

