/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.ContentMatcher;
import com.github.kristofa.test.http.DefaultContentMatcher;
import com.github.kristofa.test.http.HttpMessageHeader;
import com.github.kristofa.test.http.HttpRequest;
import com.github.kristofa.test.http.Method;
import com.github.kristofa.test.http.QueryParameter;
import com.github.kristofa.test.http.UnexpectedContentException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HttpRequestImpl
implements HttpRequest {
    private static final String NOT_SPECIFIED = "null";
    private Method method;
    private ContentMatcher contentMatcher;
    private String path;
    private final Set<QueryParameter> queryParameters = new TreeSet<QueryParameter>();
    private final Set<HttpMessageHeader> httpMessageHeaders = new TreeSet<HttpMessageHeader>();

    public HttpRequestImpl() {
        this.contentMatcher = new DefaultContentMatcher();
    }

    public HttpRequestImpl(HttpRequest request) {
        if (request instanceof HttpRequestImpl) {
            ContentMatcher otherMatcher = ((HttpRequestImpl)request).contentMatcher;
            if (otherMatcher != null) {
                this.contentMatcher = otherMatcher.copy();
            }
        } else {
            this.contentMatcher = new DefaultContentMatcher();
            try {
                this.contentMatcher.setContent(request.getContent());
            }
            catch (UnexpectedContentException e) {
                throw new IllegalStateException(e);
            }
        }
        this.method = request.getMethod();
        this.path = request.getPath();
        for (HttpMessageHeader header : request.getHttpMessageHeaders()) {
            this.httpMessageHeaders.add(new HttpMessageHeader(header.getName(), header.getValue()));
        }
        for (QueryParameter parameter : request.getQueryParameters()) {
            this.queryParameters.add(new QueryParameter(parameter.getKey(), parameter.getValue()));
        }
    }

    public HttpRequestImpl method(Method method) {
        this.method = method;
        return this;
    }

    public HttpRequestImpl content(byte[] content) {
        try {
            this.contentMatcher.setContent(content);
        }
        catch (UnexpectedContentException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public HttpRequestImpl contentMatcher(ContentMatcher matcher) throws UnexpectedContentException {
        Validate.notNull((Object)matcher);
        byte[] content = this.contentMatcher.getContent();
        if (content != null) {
            matcher.setContent(content);
            this.contentMatcher = matcher;
        } else {
            this.contentMatcher = matcher;
        }
        return this;
    }

    public HttpRequestImpl path(String path) {
        this.path = path;
        return this;
    }

    public HttpRequestImpl queryParameter(String key, String value) {
        this.queryParameters.add(new QueryParameter(key, value));
        return this;
    }

    public HttpRequestImpl removeQueryParameter(String key, String value) {
        this.queryParameters.remove(new QueryParameter(key, value));
        return this;
    }

    public HttpRequestImpl removeQueryParameters(String key) {
        HashSet<QueryParameter> toRemove = new HashSet<QueryParameter>();
        for (QueryParameter qp : this.queryParameters) {
            if (!qp.getKey().equals(key)) continue;
            toRemove.add(qp);
        }
        this.queryParameters.removeAll(toRemove);
        return this;
    }

    public HttpRequestImpl httpMessageHeader(String name, String value) {
        this.httpMessageHeaders.add(new HttpMessageHeader(name, value));
        return this;
    }

    public HttpRequestImpl removeHttpMessageHeader(String name, String value) {
        this.httpMessageHeaders.remove(new HttpMessageHeader(name, value));
        return this;
    }

    public HttpRequestImpl removeHttpMessageHeaders(String name) {
        HashSet<HttpMessageHeader> toRemove = new HashSet<HttpMessageHeader>();
        for (HttpMessageHeader header : this.httpMessageHeaders) {
            if (!header.getName().equals(name)) continue;
            toRemove.add(header);
        }
        this.httpMessageHeaders.removeAll(toRemove);
        return this;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public byte[] getContent() {
        if (this.contentMatcher == null) {
            return null;
        }
        byte[] content = this.contentMatcher.getContent();
        if (content == null) {
            return null;
        }
        return Arrays.copyOf(content, content.length);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<QueryParameter> getQueryParameters() {
        return Collections.unmodifiableSet(this.queryParameters);
    }

    @Override
    public Set<HttpMessageHeader> getHttpMessageHeaders() {
        return Collections.unmodifiableSet(this.httpMessageHeaders);
    }

    @Override
    public Set<QueryParameter> getQueryParameters(String key) {
        Validate.notBlank((CharSequence)key);
        TreeSet<QueryParameter> qpSubset = new TreeSet<QueryParameter>();
        for (QueryParameter qp : this.queryParameters) {
            if (!qp.getKey().equals(key)) continue;
            qpSubset.add(qp);
        }
        return qpSubset;
    }

    @Override
    public Set<HttpMessageHeader> getHttpMessageHeaders(String name) {
        Validate.notBlank((CharSequence)name);
        TreeSet<HttpMessageHeader> mhSubset = new TreeSet<HttpMessageHeader>();
        for (HttpMessageHeader header : this.httpMessageHeaders) {
            if (!header.getName().equals(name)) continue;
            mhSubset.add(header);
        }
        return mhSubset;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    public String toString() {
        String methodString = this.add("Method: ", (Object)this.getMethod());
        String messageHeaderString = this.add("Message Header: ", this.getHttpMessageHeaders());
        String pathString = this.add("Path: ", this.getPath());
        String queryParamsString = this.add("Query Parameters: ", this.getQueryParameters());
        String contentString = null;
        contentString = this.getContent() == null ? this.add("Content:\n", this.getContent()) : this.add("Content:\n", new String(this.getContent()));
        Object[] array = new String[]{methodString, messageHeaderString, pathString, queryParamsString, contentString};
        return StringUtils.join((Object[])array, (String)"\n");
    }

    private String add(String value, Object object) {
        if (object != null) {
            return value + object;
        }
        return value + NOT_SPECIFIED;
    }
}

